# -*- coding: utf-8 -*-
import base64
import datetime
import hashlib
import random
import string

from Config.common_config import ACCOUNT_STATUS
from Model.Agent.AgentAccountModel import AgentAccount
from Model.Agent.AgentSpotModel import AgentSpot
from Model.Base import db
from Model.Spot.SpotModel import Spot
from Service.SpotService import SpotService


class AgentService():
    @staticmethod
    def gene_salt(length=16):
        key_list = [random.choice((string.ascii_letters + string.digits)) for i in range(length)]
        return ("".join(key_list))

    @staticmethod
    def gene_agent_code(agent_info, salt):
        m = hashlib.md5()
        str = "%s-%s-%s-%s" % (agent_info.id, agent_info.user_name, agent_info.phone, salt)
        m.update(str.encode("utf-8"))
        return m.hexdigest()

    @staticmethod
    def gene_pwd(pwd, salt):
        m = hashlib.md5()
        str = "%s-%s" % (base64.encodebytes(pwd.encode("utf-8")), salt)
        m.update(str.encode("utf-8"))
        return m.hexdigest()

    @staticmethod
    def check_agent_token(token):
        token = base64.b64decode(token).decode("utf-8")
        try:
            agent_info = AgentAccount.query.filter_by(access_token=token).first()
        except Exception as e:
            return 1

        if not agent_info:
            return 1

        s = token.split("#")
        if len(s) != 2:
            return 1

        if AgentService.gene_agent_code(agent_info, agent_info.salt) != s[0]:
            return 1

        if agent_info.expire_time < datetime.datetime.now():
            return 2

        return agent_info

    @staticmethod
    def create_agent_no():
        '''
        生成用户编号
        :return:
        '''
        ran_int = str(random.randint(1, 999999)).zfill(6)
        return 'ssw' + ran_int

    @staticmethod
    def get_spot_info(agent_info):
        spot_info = []
        if agent_info.level == 2 or agent_info.level == 3 or agent_info.level == 4 or agent_info.level == 5:
            infos = db.session.query(AgentAccount, AgentSpot, Spot).join(AgentSpot,
                                                                         AgentAccount.id == AgentSpot.agent_no).join(
                Spot, Spot.id == AgentSpot.spot_no).filter(AgentAccount.id == agent_info.id,
                                                           AgentAccount.status == ACCOUNT_STATUS['on_use'],
                                                           AgentSpot.status == ACCOUNT_STATUS['on_use']).all()
            for info in infos:
                cur_info = {}
                cur_info['id'] = info.Spot.id
                cur_info['spotname'] = info.Spot.spotname
                cur_info['letter'] = SpotService.get_pinyin(info.Spot.spotname)
                spot_info.append(cur_info)
        else:
            infos = Spot.query.with_entities(Spot.id, Spot.spotname).all()
            for info in infos:
                cur_info = {}
                cur_info['id'] = info.id
                cur_info['spotname'] = info.spotname
                cur_info['letter'] = SpotService.get_pinyin(info.spotname)
                spot_info.append(cur_info)
        return spot_info
