# -*- coding: utf-8 -*-
import datetime
import json

import requests
from flask import Blueprint, jsonify, request
from sqlalchemy import or_
from sqlalchemy.exc import SQLAlchemyError

from Config.base_config import ACTION_PWD
from Libs.ErrorTips import BASE_RESPONSE, REFUND_NOT_RENT_INFO, REFUND_BACK_TIME_ERROR, REFUND_NOT_PRODUCTION_INFO, \
    REFUND_MONEY_IS_ZERO, ACTION_CODE_ERROR, PARAMETER_ERROR
from Libs.Helper import Helper
from Libs.Logger import logger
from Model.Base import db
from Model.Customer.CustomerModel import Customer
from Model.Machine.MachineModel import Machine
from Model.Power.PowerModel import Power
from Model.Production.ProductionModel import Production
from Model.Rent.RentModel import Rent
from Model.Rent.RentRefundModel import RentRefund
from Service.IndexService import IndexService
from Service.RentService import RentService
from Service.WeChatService import WeChatService

route_rent = Blueprint('rent', __name__)


@route_rent.route('/test')
def test():
    return jsonify({'code': 200, 'msg': 'success'})


@route_rent.route('/list', methods=['GET', 'POST'])
def rent_list():
    json_data = request.get_json()
    spot_id = json_data['spot_id'] if 'spot_id' in json_data else 0
    data_type = json_data['data_type'] if 'data_type' in json_data else 0  # 0:今日 1:昨日 2:近7天 3 所有

    page = json_data['page'] if 'page' in json_data else 0
    limit = json_data['limit'] if 'limit' in json_data else 10

    if data_type not in [0, 1, 2, 3]:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='type error').to_dict())

    if data_type == 0:
        start_time, end_time = Helper.getTodayDate()
        info = RentService.get_rent_production_info(spot_id, start_time, end_time)
        total_income, total_rent = IndexService.get_total_production(spot_id, start_time, end_time)
        return jsonify({'error_code': 200, 'error_message': 'Success', 'data': info,
                        'detail': {'total_income': total_income, 'total_rent': total_rent}})
    elif data_type == 1:
        start_time, end_time = Helper.getYesterdayDate()
        info = RentService.get_rent_production_all(spot_id, start_time, end_time, page, limit)
        total_income, total_rent = IndexService.get_total_production(spot_id, start_time, end_time)
        return jsonify({'error_code': 200, 'error_message': 'Success', 'data': info,
                        'detail': {'total_income': total_income, 'total_rent': total_rent}})
    elif data_type == 2:
        start_time, end_time = Helper.getSevenDate()
        info = RentService.get_rent_production_all(spot_id, start_time, end_time, page, limit)
        total_income, total_rent = IndexService.get_total_production(spot_id, start_time, end_time)
        return jsonify({'error_code': 200, 'error_message': 'Success', 'data': info,
                        'detail': {'total_income': total_income, 'total_rent': total_rent}})
    else:
        start_time, end_time = Helper.getMonthDate()
        info = RentService.get_not_return_production(spot_id, start_time, end_time)
        return jsonify(BASE_RESPONSE(data=info).to_dict())


@route_rent.route('/detail', methods=['GET', 'POST'])
def rent_detail():
    json_data = request.get_json()
    rent_no = json_data['rent_no'] if 'rent_no' in json_data else ''
    hatch_no = json_data['hatch_no'] if 'hatch_no' in json_data else ''
    # data = RentService.get_production_detail(rent_no, hatch_no)
    data = RentService.get_production_detail_new(rent_no, hatch_no)
    return jsonify(BASE_RESPONSE(data=data).to_dict())


@route_rent.route('/refund_old', methods=['GET', 'POST'])
def rent_refund_old():
    json_data = request.get_json()
    device_id = json_data['device_id'] if 'device_id' in json_data else ''
    power_no = json_data['power_no'] if 'power_no' in json_data else ''
    rent_no = json_data['rent_no'] if 'rent_no' in json_data else ''
    back_time = json_data['back_time'] if 'back_time' in json_data else ''
    code = json_data['code'] if 'code' in json_data else ''

    data = {
        'device_id': device_id,
        'power_no': power_no,
        'rent_no': rent_no,
        'back_time': back_time,
        'code': code
    }
    headers = {'Content-Type': 'application/xml'}
    url = 'https://guide.ssw-htzn.com/tour/rent/do_return'
    result = requests.post(url, json=data, headers=headers)
    if result:
        response = json.loads(result.text)
        return jsonify(response)
    return jsonify(BASE_RESPONSE(error_code=-1, error_message='Fail').to_dict())


@route_rent.route('/refund', methods=['GET', 'POST'])
def rent_refund():
    json_data = request.get_json()
    refund_type = json_data['type'] if 'type' in json_data else 0
    rent_no = json_data['rent_no'] if 'rent_no' in json_data else ''
    hatch_no = json_data['hatch_no'] if 'hatch_no' in json_data else 0
    comment = json_data['comment'] if 'comment' in json_data else ''

    production_info = db.session.query(Rent, Machine, Production).outerjoin(Machine,
                                                                            Machine.id == Rent.machine_id).join(
        Production, Production.rent_id == Rent.id).filter(Rent.rent_no == rent_no,
                                                          Production.rent_hatch_no == hatch_no).first()

    if not production_info:
        return jsonify(REFUND_NOT_RENT_INFO)

    device_id = production_info.Machine.he_cloud_device_id
    power_no = production_info.Production.power_no
    rent_time = production_info.Rent.pay_time

    if refund_type == '1':
        # 正常归还
        # back_time = rent_time + datetime.timedelta(hours=1)
        now = datetime.datetime.now()
        back_time = Helper.getFormatDate(now)
    elif refund_type == '2':
        # 全额归还
        back_time = rent_time + datetime.timedelta(seconds=30)
    elif refund_type == '3':
        # 手动选择时间
        back_time = json_data['back_time'] if 'back_time' in json_data else ''
    else:
        back_time = ''

    if not back_time:
        return jsonify(REFUND_BACK_TIME_ERROR)

    # power_no = power_no[4:]
    logger.info(power_no)
    logger.info(device_id)
    logger.info(rent_no)
    logger.info(back_time)
    power = Power.query.filter_by(power_no=power_no).first()
    if power:
        db.session.delete(power)

    info = db.session.query(Production, Rent).join(Rent, Rent.id == Production.rent_id).filter(
        Production.power_no == power_no, Production.is_refund == 0, Rent.rent_no == rent_no).first()
    if not info:
        logger.info('no production')
        return jsonify(REFUND_NOT_PRODUCTION_INFO)

    production = info.Production
    rent = info.Rent

    fee = RentService.check_fee(rent.pay_time.strftime('%Y-%m-%d %H:%M:%S'), str(back_time), rent.one_day_price,
                                rent.free_time)
    total = fee['total'] if fee['total'] < rent.deposit else rent.deposit

    refund_money = rent.deposit - total

    if refund_money <= 0:
        logger.info('refund money is 0')
        return jsonify(REFUND_MONEY_IS_ZERO)

    refund_no = RentService.create_refund_no()
    data = {
        "out_refund_no": refund_no,
        "out_trade_no": rent.rent_no,
        "total_fee": rent.deposit * rent.number,
        "refund_fee": refund_money
    }

    result = WeChatService().refund(data)
    if result:
        try:
            rent.total = rent.total + total
            rent.real_total = rent.real_total + total
            rent.is_over = 1
            rent.over_time = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
            rent.back_money = rent.back_money + refund_money

            # production.is_out = 1
            production.is_return = 1
            production.return_machine_id = production_info.Machine.id
            production.return_time = back_time
            production.total = total
            production.is_refund = 1
            production.refund_no = refund_no
            if refund_type == '1':
                production.return_hatch_no = production_info.Production.rent_hatch_no
            else:
                production.return_hatch_no = 127

            # log
            if refund_type == '2':
                rent_refund = RentRefund()
                rent_refund.refund_no = refund_no
                rent_refund.production_id = production.id
                rent_refund.fee = rent.one_day_price
                rent_refund.comment = comment
                rent_refund.created_at = datetime.datetime.now()
                rent_refund.updated_at = datetime.datetime.now()
                db.session.add(rent_refund)

            db.session.add(production)
            db.session.add(rent)
            db.session.commit()
        except SQLAlchemyError as e:
            db.session.rollback()
            raise e
        return jsonify(BASE_RESPONSE().to_dict())
    else:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='refund failed').to_dict())


@route_rent.route('/query_refund', methods=['GET', 'POST'])
def rent_query_refund():
    json_data = request.get_json()
    refund_no = json_data['refund_no'] if 'refund_no' in json_data else ''

    refund_data = {
        "out_refund_no": refund_no
    }
    result = WeChatService().query_refund_info(refund_data)
    if not result:
        return jsonify(BASE_RESPONSE().to_dict())

    data = {}
    if result['return_code'] == 'FAIL':
        data['error_code'] = result['return_code']
        data['error_message'] = '系统错误，请稍后再查询'
        return jsonify(data)
    if result['result_code'] == 'FAIL':
        data['error_code'] = result['err_code']
        data['error_message'] = result['err_code_des'] if 'err_code_des' in result.keys() else '退款单号异常, 请重新退款或者联系技术'
        return jsonify(data)

    if result['refund_status_0'] == 'SUCCESS':
        data['refund_status'] = '退款成功'
        data['refund_success_time'] = result['refund_success_time_0']
    elif result['refund_status_0'] == 'REFUNDCLOSE':
        data['refund_status'] = '退款关闭'
    elif result['refund_status_0'] == 'PROCESSING':
        data['refund_status'] = '退款中'
    elif result['refund_status_0'] == 'CHANGE':
        data['refund_status'] = '退款异常，请联系技术'
    else:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='failed').to_dict())

    data['refund_recv_accout'] = result['refund_recv_accout_0']
    return jsonify(BASE_RESPONSE(data=data).to_dict())


@route_rent.route('/search_rent', methods=['GET', 'POST'])
def rent_search():
    json_data = request.get_json()
    key_word = json_data['word'] if 'word' in json_data else ''
    page = json_data['page'] if 'page' in json_data else 1
    limit = json_data['limit'] if 'limit' in json_data else 10
    if not key_word:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='no key word').to_dict())

    info = RentService.get_search_info_(key_word, int(page), int(limit))
    return jsonify(BASE_RESPONSE(data=info).to_dict())


@route_rent.route('/rent_money_refund', methods=['GET', 'POST'])
def rent_money_refund():
    json_data = request.get_json()
    action_pwd = json_data['action_pwd'] if 'action_pwd' in json_data else ''

    if action_pwd != ACTION_PWD:
        return jsonify(ACTION_CODE_ERROR)

    rent_no = json_data['rent_no'] if 'rent_no' in json_data else ''
    hatch_no = json_data['hatch_no'] if 'hatch_no' in json_data else ''
    comment = json_data['comment'] if 'comment' in json_data else ''

    if not rent_no or not hatch_no or not comment:
        return jsonify(PARAMETER_ERROR)

    rent_info = db.session.query(Production, Rent).join(Rent, Rent.id == Production.rent_id).filter(
        Production.rent_hatch_no == hatch_no, Rent.rent_no == rent_no).first()

    if not rent_info:
        return jsonify(REFUND_NOT_PRODUCTION_INFO)

    real_total_consume = rent_info.Rent.deposit * rent_info.Rent.number - rent_info.Rent.back_money
    real_single_refund = real_total_consume if real_total_consume < rent_info.Production.total else rent_info.Production.total

    rent_refund_no = RentService.create_refund_no()

    rent_info.Rent.back_money = rent_info.Rent.deposit * rent_info.Rent.number \
        if rent_info.Rent.back_money + real_single_refund > rent_info.Rent.deposit * rent_info.Rent.number \
        else rent_info.Rent.back_money + real_single_refund

    rent_total = rent_info.Rent.total - rent_info.Production.total
    rent_real_total = rent_info.Rent.real_total - real_single_refund
    rent_info.Rent.total = rent_total if rent_total > 0 else 0
    rent_info.Rent.real_total = rent_real_total if rent_real_total > 0 else 0

    data = {
        "out_refund_no": rent_refund_no,
        "out_trade_no": rent_info.Rent.rent_no,
        "total_fee": rent_info.Rent.deposit * rent_info.Rent.number,
        "refund_fee": real_single_refund
    }
    result = WeChatService().refund(data)
    if result:
        try:
            rent_refund = RentRefund()
            rent_refund.refund_no = rent_refund_no
            rent_refund.production_id = rent_info.Production.id
            rent_refund.fee = real_single_refund
            rent_refund.comment = comment
            rent_refund.created_at = datetime.datetime.now()
            rent_refund.updated_at = datetime.datetime.now()

            rent_info.Production.total = 0

            db.session.add(rent_refund)
            db.session.add(rent_info.Rent)
            db.session.add(rent_info.Production)
            db.session.commit()
        except SQLAlchemyError as e:
            db.session.rollback()
            raise e
        return jsonify(BASE_RESPONSE().to_dict())
    else:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='refund failed').to_dict())


@route_rent.route('/force_refund', methods=['GET', 'POST'])
def force_refund():
    json_data = request.get_json()
    action_pwd = json_data.get('action_pwd', None)
    if action_pwd != ACTION_PWD:
        return jsonify(ACTION_CODE_ERROR)

    refund_type = json_data.get('type', None)
    rent_no = json_data.get('rent_no', None)
    comment = json_data.get('comment', None)

    logger.info('type')
    logger.info(refund_type)
    logger.info('rent_no')
    logger.info(rent_no)
    logger.info('comment')
    logger.info(comment)

    if not refund_type or not rent_no:
        return jsonify(PARAMETER_ERROR)

    rent_info = db.session.query(Production, Rent).join(Rent, Rent.id == Production.rent_id).filter(
        Rent.rent_no == rent_no).first()

    if not rent_info:
        logger.info('no production')
        return jsonify(REFUND_NOT_PRODUCTION_INFO)

    if refund_type == '1':
        # 扣15元, 退84元
        money = 8400
    elif refund_type == '2':
        # 扣25元，退74元
        money = 7400
    elif refund_type == '3':
        # 按时间扣款
        back_time = json_data.get('back_time', None)

        logger.info('back time')
        logger.info(back_time)

        if not comment or not back_time:
            return jsonify(PARAMETER_ERROR)

        money = RentService.check_fee_liuyuan(rent_info.Rent.pay_time.strftime('%Y-%m-%d %H:%M:%S'), back_time,
                                              rent_info.Rent.one_day_price, rent_info.Rent.free_time)
    # elif refund_type == '4':
    #     # 退10元
    #     if not comment:
    #         return jsonify(PARAMETER_ERROR)
    #
    #     money = 1000
    # elif refund_type == '5':
    #     # 退15元
    #     if not comment:
    #         return jsonify(PARAMETER_ERROR)
    #
    #     money = 1500
    # elif refund_type == '6':
    #     # 退25元
    #     if not comment:
    #         return jsonify(PARAMETER_ERROR)
    #
    #     money = 2500
    else:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='refund type error!').to_dict())

    production = rent_info.Production
    rent = rent_info.Rent

    rent_refund_no = RentService.create_refund_no()

    data = {
        "out_refund_no": rent_refund_no,
        "out_trade_no": rent_info.Rent.rent_no,
        "total_fee": rent_info.Rent.deposit,
        "refund_fee": int(money)
    }

    result = WeChatService().refund(data)

    if result:
        try:
            rent.total = rent.deposit - int(money)
            rent.real_total = rent.deposit - int(money)
            rent.is_over = 1
            rent.over_time = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
            rent.back_money += int(money)

            production.is_return = 1
            production.return_machine_id = production.rent_machine_id
            production.return_time = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
            production.total = rent.deposit - int(money)
            production.is_refund = 1
            production.refund_no = rent_refund_no
            production.return_hatch_no = production.rent_hatch_no

            # rent_refund_log = RentRefund()
            # rent_refund_log.refund_no = rent_refund_no
            # rent_refund_log.production_id = production.id
            # rent_refund_log.fee = int(money)
            # rent_refund_log.comment = comment
            # rent_refund_log.created_at = datetime.datetime.now()
            # rent_refund_log.updated_at = datetime.datetime.now()
            # db.session.add(rent_refund_log)

            db.session.add(production)
            db.session.add(rent)
            db.session.commit()
        except SQLAlchemyError as e:
            db.session.rollback()
            raise e
        return jsonify(BASE_RESPONSE().to_dict())
    else:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='refund failed!').to_dict())


@route_rent.route('/liuyuan_refund', methods=['GET', 'POST'])
def rent_money_liuyuan():
    json_data = request.get_json()
    action_pwd = json_data['action_pwd'] if 'action_pwd' in json_data else ''

    if action_pwd != ACTION_PWD:
        return jsonify(ACTION_CODE_ERROR)

    refund_type = json_data.get('type', None)
    rent_no = json_data.get('rent_no', None)
    comment = json_data.get('comment', None)

    logger.info('type')
    logger.info(refund_type)
    logger.info('rent_no')
    logger.info(rent_no)
    logger.info('comment')
    logger.info(comment)

    if not refund_type or not rent_no or not comment:
        return jsonify(PARAMETER_ERROR)

    rent_info = db.session.query(Production, Rent).join(Rent, Rent.id == Production.rent_id).filter(
        Rent.rent_no == rent_no).first()

    if not rent_info:
        return jsonify(REFUND_NOT_PRODUCTION_INFO)

    real_total_consume = rent_info.Rent.deposit * rent_info.Rent.number - rent_info.Rent.back_money

    if refund_type == '1':
        # 退10元
        money = 1000
    elif refund_type == '2':
        # 退15元
        money = 1500
    elif refund_type == '3':
        # 退25元
        money = 2500
    elif refund_type == '4':
        # 退5元
        money = 500
    else:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='refund type error!').to_dict())

    if money > real_total_consume:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='refund fee 大于可退金额！').to_dict())

    rent_refund_no = RentService.create_refund_no()

    data = {
        "out_refund_no": rent_refund_no,
        "out_trade_no": rent_info.Rent.rent_no,
        "total_fee": rent_info.Rent.deposit * rent_info.Rent.number,
        "refund_fee": int(money),
    }

    result = WeChatService().refund(data)
    if result:
        try:
            rent_info.Rent.total -= int(money)
            rent_info.Rent.real_total -= int(money)
            rent_info.Rent.back_money += int(money)

            # rent_refund_log = RentRefund()
            # rent_refund_log.refund_no = rent_refund_no
            # rent_refund_log.production_id = rent_info.Production.id
            # rent_refund_log.fee = int(money)
            # rent_refund_log.comment = comment
            # rent_refund_log.created_at = datetime.datetime.now()
            # rent_refund_log.updated_at = datetime.datetime.now()

            rent_info.Production.total -= int(money)

            # db.session.add(rent_refund_log)
            db.session.add(rent_info.Rent)
            db.session.add(rent_info.Production)
            db.session.commit()
        except SQLAlchemyError as e:
            db.session.rollback()
            raise e
        return jsonify(BASE_RESPONSE().to_dict())
    else:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='refund failed').to_dict())
