# -*- coding: utf-8 -*-
import logging
import os
from logging.handlers import TimedRotatingFileHandler

class Log(object):

    def __init__(self, name, level=logging.DEBUG):
        self.name = name
        self.level = level
        self.path = os.getcwd() + "/logs/"
        self.formatter = logging.Formatter("%(asctime)s - %(filename)s -[line:%(lineno)d] - %(levelname)s: %(message)s",
                                           "%Y-%m-%d %H:%M:%S")

    def getLogger(self):
        logger = logging.getLogger(self.name)
        logger.setLevel(self.level)

        # logger.addHandler(self.get_file_handler())
        logger.addHandler(self.get_console_handler())
        return logger

    def get_file_handler(self):
        file_name = "{0}{1}.log".format(self.path, self.name)
        file_handler = TimedRotatingFileHandler(
            filename=file_name,
            when="D",
            interval=1,
            backupCount=7
        )
        file_handler.suffix = "%Y-%m-%d"
        file_handler.setLevel(self.level)
        file_handler.setFormatter(self.formatter)
        return file_handler

    def get_console_handler(self):
        console_handler = logging.StreamHandler()
        console_handler.setLevel(self.level)
        console_handler.setFormatter(self.formatter)
        return console_handler

logger = Log(name='main').getLogger()
