# -*- coding: utf-8 -*-
from abc import ABCMeta, abstractmethod


class Message(metaclass=ABCMeta):
    def __init__(self, device_id):
        self.device_id = device_id

    def get_device_id(self):
        return self.device_id

    def set_device_id(self, device_id):
        self.device_id = device_id

    @abstractmethod
    def pack(self):
        pass

    @abstractmethod
    def unpack(self, value):
        pass


class CommandMessage(Message):
    def __init__(self, device_id, command, *param):
        super().__init__(device_id)
        self.command = command
        self.param = param

    def get_command(self):
        return self.command

    def set_command(self, command):
        self.command = command

    def pack(self):
        params = (str(i) for i in self.param)
        msg = "{" + self.command + ''.join(params) + "}"
        return msg

    def unpack(self, value):
        print('unpack')
