# -*- coding: utf-8 -*-
import datetime
import random

from sqlalchemy import or_

from Libs.Helper import Helper
from Model.Base import db
from Model.Customer.CustomerModel import Customer
from Model.Machine.MachineModel import Machine
from Model.Production.ProductionModel import Production
from Model.Rent.RentModel import Rent
from Model.Rent.RentRefundModel import RentRefund
from Model.Spot.SpotModel import Spot


class RentService():
    @staticmethod
    def get_rent_production_all(spot_id, start_time, end_time, page, limit):
        where = {
            Rent.spot_id == spot_id,
            Production.created_at >= start_time,
            Production.created_at <= end_time
        }
        rent_info = db.session.query(Rent, Production).join(Production, Production.rent_id == Rent.id).filter(
            *where).order_by(Production.created_at.desc()).slice(page * limit, (page + 1) * limit).all()
        data = []
        for info in rent_info:
            cur_info = {}
            cur_info['rent_no'] = info.Rent.rent_no
            cur_info['hatch_no'] = info.Production.rent_hatch_no
            cur_info['total'] = 0 if info.Production.total is None else info.Production.total
            if info.Production.is_return == 1:
                if cur_info['total'] <= 0:
                    if info.Production.return_hatch_no == 127:
                        cur_info['status'] = 3
                    else:
                        cur_info['status'] = 2
                else:
                    cur_info['status'] = 1
            else:
                cur_info['status'] = 0
            data.append(cur_info)
        return data

    @staticmethod
    def get_not_return_production(spot_id, start_time, end_time):
        where = {
            Rent.spot_id == spot_id,
            Production.is_out == 1,
            Production.is_return == 0,
            Production.created_at >= start_time,
            Production.created_at <= end_time
        }
        rent_info = db.session.query(Rent, Production).join(Production, Production.rent_id == Rent.id).filter(
            *where).order_by(Production.created_at.desc()).all()
        data = []
        for info in rent_info:
            tmp = {
                'rent_no': info.Rent.rent_no,
                'hatch_no': info.Production.rent_hatch_no,
                'total': 0 if info.Production.total is None else info.Production.total,
                'status': 0
            }
            data.append(tmp)
        return data

    @staticmethod
    def get_rent_production_info(spot_id, start_time, end_time):
        where = {
            Rent.spot_id == spot_id,
            Production.created_at >= start_time,
            Production.created_at <= end_time
        }
        rent_info = db.session.query(Rent, Production).join(Production, Production.rent_id == Rent.id).filter(
            *where).order_by(Production.created_at.desc()).all()
        data = []
        for info in rent_info:
            cur_info = {}
            cur_info['rent_no'] = info.Rent.rent_no
            cur_info['hatch_no'] = info.Production.rent_hatch_no
            cur_info['total'] = 0 if info.Production.total is None else info.Production.total
            if info.Production.is_return == 1:
                if cur_info['total'] <= 0:
                    if info.Production.return_hatch_no == 127:
                        cur_info['status'] = 3
                    else:
                        cur_info['status'] = 2
                else:
                    cur_info['status'] = 1
            else:
                cur_info['status'] = 0
            data.append(cur_info)
        return data

    @staticmethod
    def get_production_detail_new(rent_no, hatch_no):
        sql = '''
            SELECT rent.deposit, rent.is_over, production.is_return, production.total, production.return_hatch_no,
            production.rent_machine_id, rent.customer_id, rent.real_total, rent.rent_no, production.return_time,
            rent.free_time, rent.one_day_price, rent.pay_time, rent.spot_id, production.is_refund, production.refund_no,
            rent_refund.refund_no AS rent_refund_no FROM rent
            LEFT JOIN production ON production.rent_id  = rent.id
            LEFT JOIN rent_refund ON rent_refund.production_id = production.id
            WHERE rent.rent_no = "{rent_no}" AND production.rent_hatch_no = {hatch_no}
        '''.format(rent_no=rent_no, hatch_no=hatch_no)
        production_info = db.session.execute(sql)
        total_info = []
        for info in production_info:
            cur_info = {}
            cur_info['deposit'] = info.deposit
            cur_info['is_return'] = info.is_over
            if info.is_return == 1:
                if info.total <= 0:
                    if info.return_hatch_no == 127:
                        cur_info['status'] = 3
                    else:
                        cur_info['status'] = 2
                else:
                    cur_info['status'] = 1
            else:
                cur_info['status'] = 0

            cur_info['mac_no'] = RentService.get_rent_machine(info.rent_machine_id)
            cur_info['phone'] = RentService.get_customer_phone(info.customer_id)
            cur_info['real_total'] = info.real_total
            cur_info['rent_no'] = info.rent_no
            cur_info['rent_over_time'] = None if not info.return_time else Helper.getFormatDate(info.return_time)
            cur_info['rent_price'] = str(info.free_time) + '分钟内免费，日租金' + str(
                round(info.one_day_price / 100, 2)) + '元/个'
            cur_info['rent_start_time'] = Helper.getFormatDate(info.pay_time)
            cur_info['spot_name'] = RentService.get_rent_spot_name(info.spot_id)

            cur_info['is_refund'] = info.is_refund
            cur_info['refund_no'] = info.refund_no
            cur_info['rent_refund_no'] = info.rent_refund_no
            total_info.append(cur_info)
        return total_info

    @staticmethod
    def get_production_detail(rent_no, hatch_no):
        production_info = db.session.query(Rent, Production).join(Production, Production.rent_id == Rent.id).filter(
            Rent.rent_no == rent_no, Production.rent_hatch_no == hatch_no).all()
        total_info = []
        for info in production_info:
            cur_info = {}
            cur_info['deposit'] = info.Rent.deposit
            cur_info['is_return'] = info.Rent.is_over

            if info.Production.is_return == 1:
                if info.Production.total <= 0:
                    cur_info['status'] = 2
                elif info.Production.return_hatch_no == 127:
                    cur_info['status'] = 3
                else:
                    cur_info['status'] = 1
            else:
                cur_info['status'] = 0

            cur_info['mac_no'] = RentService.get_rent_machine(info.Production.rent_machine_id)
            cur_info['phone'] = RentService.get_customer_phone(info.Rent.customer_id)
            cur_info['real_total'] = info.Rent.real_total
            cur_info['rent_no'] = info.Rent.rent_no
            cur_info['rent_over_time'] = Helper.getFormatDate(info.Production.return_time)
            cur_info['rent_price'] = str(info.Rent.free_time) + '分钟内免费，日租金' + str(
                round(info.Rent.one_day_price / 100, 2)) + '元/个'
            cur_info['rent_start_time'] = Helper.getFormatDate(info.Rent.pay_time)
            cur_info['spot_name'] = RentService.get_rent_spot_name(info.Rent.spot_id)

            cur_info['is_refund'] = info.Production.is_refund
            cur_info['refund_no'] = info.Production.refund_no
            total_info.append(cur_info)
        return total_info

    @staticmethod
    def get_rent_machine(machine_id):
        machine_info = Machine.query.filter(Machine.id == machine_id).first()
        if machine_info:
            return machine_info.mac_no
        return 'unknown'

    @staticmethod
    def get_rent_spot_name(spot_id):
        spot_info = Spot.query.filter(Spot.id == spot_id).first()
        if spot_info:
            return spot_info.spotname
        return 'unknown'

    @staticmethod
    def get_customer_phone(customer_id):
        customer_info = Customer.query.filter(Customer.id == customer_id).first()
        if customer_info:
            return customer_info.phone
        return 'unknown'

    @staticmethod
    def get_search_info_(key_word, page, limit):
        sql = '''
                SELECT rent.rent_no, production.rent_hatch_no, production.total, production.is_return,
                production.return_hatch_no, customers.phone, rent.pay_time FROM rent
                LEFT JOIN production ON production.rent_id = rent.id
                LEFT JOIN customers ON customers.id = rent.customer_id
                where  rent.id in 
                (select id from rent where rent_no  LIKE "%{key_word}%" or customer_id in
                (select id from customers where phone LIKE "%{key_word}%"))
                ORDER BY rent.pay_time DESC LIMIT {page},{limit} 
        '''.format(key_word=key_word, page=(page - 1) * limit, limit=limit)
        infos = db.session.execute(sql)
        data = []
        for info in infos:
            cur_info = {}
            cur_info['rent_no'] = info.rent_no
            cur_info['hatch_no'] = info.rent_hatch_no
            cur_info['total'] = info.total
            cur_info['phone'] = info.phone
            if info.is_return == 1:
                if cur_info['total'] <= 0:
                    if info.return_hatch_no == 127:
                        cur_info['status'] = 3
                    else:
                        cur_info['status'] = 2
                else:
                    cur_info['status'] = 1
            else:
                cur_info['status'] = 0
            data.append(cur_info)

        return data

    @staticmethod
    def get_search_info(key_word):
        search_info = db.session.query(Rent.rent_no, Production.rent_hatch_no, Production.total, Production.is_return,
                                       Production.return_hatch_no, Customer.phone).outerjoin(Production,
                                                                                             Production.rent_id == Rent.id).join(
            Customer,
            Customer.id == Rent.customer_id).filter(
            or_(Rent.rent_no.like('%' + str(key_word) + '%'), Customer.phone.like('%' + str(key_word) + '%'))).all()
        data = []
        for info in search_info:
            cur_info = {}
            cur_info['rent_no'] = info.rent_no
            cur_info['hatch_no'] = info.rent_hatch_no
            cur_info['total'] = info.total
            if info.is_return == 1:
                if cur_info['total'] <= 0:
                    cur_info['status'] = 2
                elif info.return_hatch_no == 127:
                    cur_info['status'] = 3
                else:
                    cur_info['status'] = 1
            else:
                cur_info['status'] = 0
            data.append(cur_info)
        return data

    @staticmethod
    def check_fee(rent_time, back_time, one_day_price, free_time):
        '''
        计算租借费用
        :param rent_time:
        :param back_time:
        :param one_day_price:
        :param free_time:
        :return:
        '''
        back_time_date = datetime.datetime.strptime(back_time, '%Y-%m-%d %H:%M:%S')
        rent_time_date = datetime.datetime.strptime(rent_time, '%Y-%m-%d %H:%M:%S')
        use_time = (back_time_date - rent_time_date).total_seconds()
        total = 0
        use_m = round(use_time / 60, 2)
        if use_time > free_time * 60:
            days = (datetime.datetime(back_time_date.year, back_time_date.month,
                                      back_time_date.day) - datetime.datetime(rent_time_date.year, rent_time_date.month,
                                                                              rent_time_date.day)).days
            total = one_day_price * (days + 1)
        return {'total': total, 'use_m': use_m}

    @staticmethod
    def create_refund_no():
        '''
        生成退款单号
        :return:
        '''
        data_str = datetime.datetime.now().strftime('%Y%m%d%H%M%S')
        int_str = str(random.randint(1, 999)).zfill(6)
        return 'RF' + data_str + int_str
