# -*- coding: utf-8 -*-
from sqlalchemy import Column, Integer, ForeignKey, Text, String, FetchedValue
from sqlalchemy.orm import relationship

from Model.Base import BaseModel


class Repair(BaseModel):
    __tablename__ = 'repairs'

    id = Column(Integer, primary_key=True)
    spot_id = Column(ForeignKey('spot.id', ondelete='CASCADE'), nullable=False, index=True, comment='景区编号')
    machine_id = Column(ForeignKey('machine.id', ondelete='CASCADE'), nullable=False, index=True, comment='机柜编号')
    system_users_id = Column(Integer, comment='商家账号id')
    remark = Column(Text, comment='问题描述')
    tel = Column(String(50), comment='联系方式')
    status = Column(Integer, server_default=FetchedValue(), comment='状态')

    machine = relationship('Machine', primaryjoin='Repair.machine_id == Machine.id', backref='repairs')
    spot = relationship('Spot', primaryjoin='Repair.spot_id == Spot.id', backref='repairs')
