# -*- coding: utf-8 -*-
import base64
import hmac
import random
import time

from flask import Blueprint, jsonify, request, g

from Libs.ErrorTips import BASE_RESPONSE
from Libs.Logger import logger
from Service.RepairService import RepairService

route_repair = Blueprint('repair', __name__)


@route_repair.route('/repair', methods=['GET', 'POST'])
def repairCreate():
    json_data = request.get_json()
    system_user_id = g.user.id
    # system_user_id = json_data['system_user_id'] if 'system_user_id' in json_data else 0
    remark = json_data['remark'] if 'remark' in json_data else ''
    tel = json_data['tel'] if 'tel' in json_data else ''
    pics = json_data['pics'] if 'pics' in json_data else []
    spot_id = json_data['spot_id'] if 'spot_id' in json_data else ''
    machine_id = json_data['machine_id'] if 'machine_id' in json_data else ''
    logger.info('####### spot id #######')
    logger.info(spot_id)
    RepairService.create(system_user_id, remark, tel, pics, spot_id, machine_id)
    return jsonify(BASE_RESPONSE().to_dict())


@route_repair.route('/tencentUploadAuthorization', methods=['POST'])
def tencentUploadAuthorization():
    json_data = request.get_json()
    app_id = '1255927177'
    bucket = 'dev'
    secret_id = 'AKIDQp9OXawOAqWAjCAr9LRRL9vcEj8QMkke'
    secret_key = 'wnXDmFbqy1yoXhmldQ8kEf1GOPLBufMy'

    postfix = json_data['postfix'] if 'postfix' in json_data else 'png'
    filename = RepairService.guid() + '.' + postfix
    pathname = '/' + app_id + '/' + bucket + '/img/' + filename

    now = int(time.time())
    randoma = random.randint(1, 9999999999)
    expired = int(time.time()) + 300
    plainText = 'a=' + app_id + '&b=' + bucket + '&k=' + secret_id + '&e=' + str(expired) + '&t=' + str(
        now) + '&r=' + str(randoma) + '&f=' + pathname
    bin = hmac.new(secret_key.encode('utf-8'), plainText.encode('utf-8'), 'SHA1').digest()
    new_bin = bin + plainText.encode()

    signature = base64.encodebytes(new_bin).decode()
    signature = signature.replace("\n", "")
    data = {'auth': signature, 'filename': pathname}
    return jsonify(BASE_RESPONSE(data=data).to_dict())
