# -*- coding: utf-8 -*-
from sqlalchemy import Column, Integer, String, FetchedValue

from Model.Base import BaseModel


class Power(BaseModel):
    __tablename__ = 'power'

    id = Column(Integer, primary_key=True)
    power_no = Column(String(191, 'utf8mb4_unicode_ci'), nullable=False, comment='充电宝编号')
    power_type = Column(String(10, 'utf8mb4_unicode_ci'), comment='讲解器类型')
    season = Column(Integer, server_default=FetchedValue(), comment='季节0暂无1春2夏3秋4冬')
    has_power = Column(Integer, nullable=False, server_default=FetchedValue(), comment='充电宝电量')
    status = Column(Integer, nullable=False, server_default=FetchedValue(), comment='充电宝状态1在仓库2在机柜可用3在机柜占用4出货成功')
    is_miss = Column(Integer, nullable=False, server_default=FetchedValue(), comment='是否丢失 0未丢 1丢失')
    machine_id = Column(Integer, comment='机柜id')
    hatch_no = Column(Integer, comment='机柜仓口号')
