# -*- coding: utf-8 -*-
from sqlalchemy import Column, Integer, String, DateTime, FetchedValue
from Model.Base import BaseModel


class Rent(BaseModel):
    __tablename__ = 'rent'

    id = Column(Integer, primary_key=True)
    rent_no = Column(String(19, 'utf8mb4_unicode_ci'), nullable=False, comment='租借单号')
    number = Column(Integer, nullable=False, comment='租借数量')
    deposit = Column(Integer, nullable=False, comment='单个押金')
    one_day_price = Column(Integer, nullable=False, comment='日单价')
    free_time = Column(Integer, nullable=False, comment='免费时间')
    machine_id = Column(Integer, nullable=False, comment='机柜id')
    power_type = Column(String(10, 'utf8mb4_unicode_ci'), comment='讲解器类型')
    customer_id = Column(Integer, nullable=False, comment='用户id')
    total = Column(Integer, nullable=False, server_default=FetchedValue(), comment='应收金额')
    real_total = Column(Integer, nullable=False, server_default=FetchedValue(), comment='实收金额')
    back_money = Column(Integer, nullable=False, server_default=FetchedValue(), comment='退款金额')
    is_pay = Column(Integer, nullable=False, server_default=FetchedValue(), comment='是否支付')
    rent_type = Column(Integer, nullable=False, server_default=FetchedValue(), comment='租借类型1现场租借2预约')
    add_time = Column(DateTime, nullable=False, server_default=FetchedValue(), comment='下单时间')
    pay_time = Column(DateTime, comment='支付时间')
    is_take = Column(Integer, nullable=False, server_default=FetchedValue(), comment='是否取货')
    take_time = Column(DateTime, comment='开始发货时间')
    is_over = Column(Integer, nullable=False, server_default=FetchedValue(), comment='是否完结')
    is_cancel = Column(Integer, nullable=False, server_default=FetchedValue(), comment='是否取消交易')
    refund_no = Column(String(191, 'utf8mb4_unicode_ci'), comment='退款单号')
    spot_id = Column(Integer, nullable=False, comment='景点id')
    business_id = Column(Integer, nullable=False, comment='商家id')
    expire_handle = Column(Integer, nullable=False, server_default=FetchedValue(), comment='是否做过期处理')
    prepay_id = Column(String(191, 'utf8mb4_unicode_ci'), comment='微信支付prepay_id')
    over_time = Column(DateTime, comment='订单完结时间')
