# -*- coding: utf-8 -*-
from sqlalchemy import Column, String, Integer

from Model.Base import BaseModel


class InvoiceRecord(BaseModel):
    __tablename__ = 'invoice_record'

    id = Column(Integer, primary_key=True)
    invoice_id = Column(Integer, nullable=False, comment='对应发票id')
    customer_id = Column(Integer, nullable=False, comment='用户id')
    company_name = Column(String(255, 'utf8mb4_unicode_ci'), nullable=False, comment='发票抬头')
    payment_id = Column(String(255, 'utf8mb4_unicode_ci'), comment='税号')
    pay_money = Column(Integer, nullable=False, comment='合计金额')
    e_account = Column(String(255, 'utf8mb4_unicode_ci'), nullable=False, comment='电子邮箱')
    remark = Column(String(255, 'utf8mb4_unicode_ci'), comment='备注')
    address = Column(String(255, 'utf8mb4_unicode_ci'), comment='地址电话')
    account = Column(String(255, 'utf8mb4_unicode_ci'), comment='开户行账号')
    parent_id = Column(Integer, nullable=False, comment='父节点')
    rent_list = Column(String(255, 'utf8mb4_unicode_ci'), nullable=False, comment='订单id列表')
    status = Column(Integer, nullable=False, comment='0：正常开发票1：等待审核2：审核成功3：驳回4：拒绝')
    reason = Column(String(255, 'utf8mb4_unicode_ci'), comment='审核理由')
