from pymongo import MongoClient
from Config.base_config import MONGO_DATABASE_URI, MONGO_DATABASE_NAME

client = MongoClient(MONGO_DATABASE_URI)
db = client[MONGO_DATABASE_NAME]


class BaseCollection(object):
    __collectionname__ = None

    def __init__(self):
        self.collection = db.get_collection(self.__collectionname__)

    # 自增函数
    def get_next_id(self):
        ret = db["ids"].find_one_and_update({"id": self.__collectionname__}, {"$inc": {"sequence": 1}})
        new = ret["sequence"]
        return new

    def insert_one(self, document: dict, bypass_document_validation=False,
                   session=None):
        document.update({"id": self.get_next_id()})
        self.collection.insert_one(document, bypass_document_validation=bypass_document_validation,
                                   session=session)
