# -*- coding: utf-8 -*-
from sqlalchemy import Column, Integer, ForeignKey, String
from sqlalchemy.orm import relationship

from Model.Base import BaseModel


class RepairImage(BaseModel):
    __tablename__ = 'repair_images'

    id = Column(Integer, primary_key=True)
    repairs_id = Column(ForeignKey('repairs.id', ondelete='CASCADE'), index=True)
    url = Column(String(200))

    repairs = relationship('Repair', primaryjoin='RepairImage.repairs_id == Repair.id', backref='repair_images')
