# -*- coding: utf-8 -*-
import datetime

from flask import Blueprint, jsonify, g, request

from Libs.ErrorTips import BASE_RESPONSE
from Model.Base import db
from Service.SpotService import SpotService

route_spot = Blueprint('spot', __name__)


# @route_spot.route('/spot_info')
# def all_spot_info():
#     info = SpotService.get_spot_info()
#     return jsonify(BASE_RESPONSE(data=info).to_dict())


@route_spot.route('/spot_info')
def all_spot_info_new():
    sql = """
                SELECT 
                s.id AS spot_id,
                s.spotname,
                aa.id AS agent_id,
                aa.user_name,
                aa.phone,
                aa.level
            FROM
                spot s
                    LEFT JOIN
                agent_spot ass ON s.id = ass.spot_no and  ass.status=1
                    LEFT JOIN
                agent_account aa ON ass.agent_no = aa.id
    """
    infos = db.session.execute(sql).fetchall()
    spot_info = {}
    agent_info = {}
    for info in infos:
        cur_info = {}
        if agent_info.get(info.phone, None) is None:
            agent_info[info.phone] = [{"spot_id": info.spot_id, "spot_name": info.spotname}]
        else:
            agent_info[info.phone].append({"spot_id": info.spot_id, "spot_name": info.spotname})

        if spot_info.get(info.spotname, None) is None:
            cur_info['id'] = info.spot_id
            cur_info['letter'] = SpotService.get_pinyin(info.spotname)
            cur_info['spotname'] = info.spotname
            cur_info['agent_info'] = [{
                "agent_name": info.user_name,
                "phone": info.phone,
                "level": info.level,
                "spot_info": agent_info[info.phone]
            }]
            spot_info[info.spotname] = cur_info
        else:
            tmp_data = {
                "agent_name": info.user_name,
                "phone": info.phone,
                "level": info.level,
                "spot_info": agent_info[info.phone]
            }
            spot_info[info.spotname]['agent_info'].append(tmp_data)
    data = list(spot_info.values())
    return jsonify(BASE_RESPONSE(data=data).to_dict())


@route_spot.route('/spot_machine_list', methods=["POST"])
def get_spot_machine_list():
    json_data = request.get_json()
    spot_id = json_data.get("spot_id")
    info = SpotService.get_spot_machine_list(spot_id)
    return jsonify(BASE_RESPONSE(data=info).to_dict())
