# -*- coding: utf-8 -*-
from Libs.Onenet.Message.Message import CommandMessage
from Libs.Onenet.OneNetApi import OneNetApi

from Config.common_config import NEW_ONENET_CONFIG as new_onenet_config, ONENET_CONFIG as onenet_config


class OneNet(object):
    @staticmethod
    def open(machine, position):
        command_message = CommandMessage(machine.he_cloud_device_id, chr(0x46), str(position - 1))
        if machine.he_cloud_device_id in new_onenet_config["he_cloud_device_id"]:
            one_api = OneNetApi(new_onenet_config["api_key"], new_onenet_config["url"])
        else:
            one_api = OneNetApi(onenet_config["api_key"], onenet_config["url"])
        result = one_api.send_data_to_edp(command_message.get_device_id(), 1, 0, command_message.pack())
        if not result or result.get("error", None) is not None:
            return False

        return True
