# -*- coding: utf-8 -*-
from sqlalchemy import Column, Integer, String, DateTime, FetchedValue
from Model.Base import BaseModel


class Customer(BaseModel):
    __tablename__ = 'customers'

    id = Column(Integer, primary_key=True)
    mini_program_open_id = Column(String(191, 'utf8mb4_unicode_ci'), comment='微信支付宝小程序openID')
    openid = Column(String(191, 'utf8mb4_unicode_ci'), comment='微信支付宝公众平台openID')
    unionid = Column(String(191, 'utf8mb4_unicode_ci'), comment='微信支付宝unionid')
    platform = Column(Integer, nullable=False, server_default=FetchedValue(), comment='平台 1微信 2支付宝')
    phone = Column(String(191, 'utf8mb4_unicode_ci'), comment='手机号')
    deposit = Column(Integer, nullable=False, server_default=FetchedValue(), comment='押金')
    language = Column(String(191, 'utf8mb4_unicode_ci'), nullable=False, comment='语种')
    nick_name = Column(String(191, 'utf8mb4_unicode_ci'), comment='昵称')
    gender = Column(Integer, nullable=False, server_default=FetchedValue(), comment='性别')
    avatar_url = Column(String(191, 'utf8mb4_unicode_ci'), comment='头像')
    status = Column(Integer, nullable=False, comment='状态 0停用 1正常')
    last_login_at = Column(DateTime, comment='上次登录时间')
