# -*- coding: utf-8 -*-
from flask import Blueprint, jsonify, request, g

from Libs.ErrorTips import BASE_RESPONSE, OPERATE_TYPE_ERROR, OPERATE_LEVEL_ERROR, OPERATE_ERROR
from Libs.Helper import Helper
from Service.AgentService import AgentService
from Service.IndexService import IndexService

route_index = Blueprint('index', __name__)


@route_index.route('/index', methods=['GET', 'POST'])
def index():
    json_data = request.get_json()
    spot_id = json_data['spot_id'] if 'spot_id' in json_data else 0
    data_type = json_data['type'] if 'type' in json_data else 1  # 1今日，2本周，3本月，4历史

    if int(data_type) not in [1, 2, 3, 4]:
        return jsonify(OPERATE_TYPE_ERROR)

    cur_user = g.user

    if int(data_type) == 2:
        # 本周数据
        start_time_week, end_time_week = Helper.getWeekDate()
        start_time_lastweek, end_time_lastweek = Helper.getLastWeekDate()
        week_income, week_rent = IndexService.get_total_production(spot_id, start_time_week, end_time_week)
        lastweek_income, lastweek_rent = IndexService.get_total_production(spot_id, start_time_lastweek,
                                                                           end_time_lastweek)
        refund_money_week, refund_rent_week = IndexService.get_refund_rent(spot_id, start_time_week, end_time_week)
        invalid_money_week, invalid_rent_week = IndexService.get_invalid_production_info(spot_id, start_time_week,
                                                                                         end_time_week)
        invalid_money_lastweek, invalid_rent_lastweek = IndexService.get_invalid_production_info(spot_id,
                                                                                                 start_time_lastweek,
                                                                                                 end_time_lastweek)
        if cur_user.level == 1:
            admin_week = {}
            admin_week['week_income'] = week_income
            admin_week['week_rent'] = week_rent
            admin_week['lastweek_income'] = lastweek_income
            admin_week['lastweek_rent'] = lastweek_rent
            admin_week['refund_money_week'] = refund_money_week
            admin_week['refund_rent_week'] = refund_rent_week
            admin_week['week_invalid_rent'] = invalid_rent_week
            admin_week['week_invalid_money'] = invalid_money_lastweek

            if lastweek_income == 0:
                admin_week['week_income_compare'] = 0
            else:
                admin_week['week_income_compare'] = round((week_income - lastweek_income) / lastweek_income, 2)

            if invalid_rent_lastweek == 0:
                admin_week['week_invalid_compare'] = 0
            else:
                admin_week['week_invalid_compare'] = round(
                    (invalid_rent_week - invalid_rent_lastweek) / invalid_rent_lastweek, 2)

            admin_week['spot_info'] = AgentService.get_spot_info(cur_user)
            return jsonify(BASE_RESPONSE(data=admin_week).to_dict())
        elif cur_user.level == 2 or cur_user.level == 4:
            return jsonify(OPERATE_LEVEL_ERROR)
        else:
            return jsonify(OPERATE_ERROR)
    elif int(data_type) == 3:
        # 本月数据
        start_time_month, end_time_month = Helper.getMonthDate()
        start_time_lastmonth, end_time_lastmonth = Helper.getLastMonthDate()
        month_income, month_rent = IndexService.get_total_production(spot_id, start_time_month, end_time_month)
        last_month_income, last_month_rent = IndexService.get_total_production(spot_id, start_time_lastmonth,
                                                                               end_time_lastmonth)
        refund_money_month, refund_rent_month = IndexService.get_refund_rent(spot_id, start_time_month, end_time_month)
        invalid_money_month, invalid_rent_month = IndexService.get_invalid_production_info(spot_id, start_time_month,
                                                                                           end_time_month)
        invalid_money_lastmonth, invalid_rent_lastmonth = IndexService.get_invalid_production_info(spot_id,
                                                                                                   start_time_lastmonth,
                                                                                                   end_time_lastmonth)
        if cur_user.level == 1:
            admin_month = {}
            admin_month['month_income'] = month_income
            admin_month['month_rent'] = month_rent
            admin_month['last_month_income'] = last_month_income
            admin_month['last_month_rent'] = last_month_rent

            admin_month['refund_money_month'] = refund_money_month
            admin_month['refund_rent_month'] = refund_rent_month
            admin_month['month_invalid_rent'] = invalid_rent_month
            admin_month['month_invalid_money'] = invalid_money_month

            if last_month_income == 0:
                admin_month['month_income_compare'] = 0
            else:
                admin_month['month_income_compare'] = round((month_income - last_month_income) / last_month_income, 2)

            if invalid_rent_lastmonth == 0:
                admin_month['month_invalid_compare'] = 0
            else:
                admin_month['month_invalid_compare'] = round(
                    (invalid_rent_month - invalid_rent_lastmonth) / invalid_rent_lastmonth, 2)

            admin_month['spot_info'] = AgentService.get_spot_info(cur_user)
            return jsonify(BASE_RESPONSE(data=admin_month).to_dict())
        elif cur_user.level == 2 or cur_user.level == 4:
            return jsonify(OPERATE_LEVEL_ERROR)
        else:
            return jsonify(OPERATE_ERROR)
    elif int(data_type) == 4:
        # 历史数据
        history_income = IndexService.get_history_income_production(spot_id)
        history_rent = IndexService.get_history_production(spot_id)
        history_refund_money, history_refund_rent = IndexService.get_history_refund_rent(spot_id)
        invalid_money_history, invalid_rent_history = IndexService.get_invalid_production_info_all(spot_id)
        if cur_user.level == 1:
            admin_history = {}
            admin_history['history_income'] = history_income
            admin_history['history_rent'] = history_rent
            admin_history['history_refund_money'] = history_refund_money
            admin_history['history_refund_rent'] = history_refund_rent
            admin_history['history_invalid_rent'] = invalid_rent_history
            admin_history['history_invalid_money'] = invalid_money_history
            admin_history['spot_info'] = AgentService.get_spot_info(cur_user)
            return jsonify(BASE_RESPONSE(data=admin_history).to_dict())
        elif cur_user.level == 2 or cur_user.level == 4:
            agent_history = {}
            start_time_week, end_time_week = Helper.getWeekDate()
            start_time_lastweek, end_time_lastweek = Helper.getLastWeekDate()
            start_time_month, end_time_month = Helper.getMonthDate()
            start_time_lastmonth, end_time_lastmonth = Helper.getLastMonthDate()
            week_income, week_rent = IndexService.get_total_production(spot_id, start_time_week, end_time_week)
            lastweek_income, lastweek_rent = IndexService.get_total_production(spot_id, start_time_lastweek,
                                                                               end_time_lastweek)
            month_income, month_rent = IndexService.get_total_production(spot_id, start_time_month, end_time_month)
            lastmonth_income, lastmonth_rent = IndexService.get_total_production(spot_id, start_time_lastmonth,
                                                                                 end_time_lastmonth)
            agent_history['week_income'] = week_income
            agent_history['week_rent'] = week_rent
            agent_history['lastweek_income'] = lastweek_income
            agent_history['lastweek_rent'] = lastweek_rent
            agent_history['history_income'] = history_income
            agent_history['history_rent'] = history_rent
            agent_history['month_income'] = month_income
            agent_history['month_rent'] = month_rent
            agent_history['lastmonth_income'] = lastmonth_income
            agent_history['lastmonth_rent'] = lastmonth_rent
            if cur_user.level == 2:
                agent_history['history_invalid_rent'] = invalid_rent_history
                agent_history['history_invalid_money'] = invalid_money_history
            agent_history['spot_info'] = AgentService.get_spot_info(cur_user)
            return jsonify(BASE_RESPONSE(data=agent_history).to_dict())
        else:
            return jsonify(OPERATE_ERROR)
    else:
        # 今日数据
        start_time_today, end_time_today = Helper.getTodayDate()
        start_time_yesterday, end_time_yesterday = Helper.getYesterdayDate()
        today_income, today_rent = IndexService.get_total_production(spot_id, start_time_today, end_time_today)
        yesterday_income, yesterday_rent = IndexService.get_total_production(spot_id, start_time_yesterday,
                                                                             end_time_yesterday)
        rent_finish = IndexService.get_total_power(spot_id, start_time_today, end_time_today)
        rent_not_return = IndexService.get_not_return_production(spot_id, start_time_today, end_time_today)
        today_discount = IndexService.get_discount_money(spot_id, start_time_today, end_time_today)
        rent_invalid_money, rent_invalid_rent = IndexService.get_invalid_production_info(spot_id, start_time_today,
                                                                                         end_time_today)

        if cur_user.level == 1:
            # 超级管理员
            admin_today = {}
            admin_today['today_income'] = today_income
            admin_today['today_rent'] = today_rent
            admin_today['yesterday_income'] = yesterday_income
            admin_today['yesterday_rent'] = yesterday_rent
            admin_today['rent_finish'] = rent_finish
            admin_today['rent_not_return'] = rent_not_return
            admin_today['today_invalid_rent'] = rent_invalid_rent
            admin_today['today_invalid_money'] = rent_invalid_money
            admin_today['discount'] = today_discount
            refund_money_today, refund_rent_today = IndexService.get_refund_rent(spot_id, start_time_today,
                                                                                 end_time_today)
            refund_money_yesterday, refund_rent_yesterday = IndexService.get_refund_rent(spot_id,
                                                                                         start_time_yesterday,
                                                                                         end_time_yesterday)
            admin_today['refund_rent'] = refund_rent_today
            admin_today['refund_money'] = refund_money_today
            if refund_money_yesterday == 0:
                admin_today['refund_compare'] = round((refund_money_today - refund_money_yesterday) * 100, 2)
            else:
                admin_today['refund_compare'] = round(
                    (refund_money_today - refund_money_yesterday) / refund_money_yesterday, 2)

            admin_today['spot_info'] = AgentService.get_spot_info(cur_user)

            return jsonify(BASE_RESPONSE(data=admin_today).to_dict())
        elif cur_user.level == 2 or cur_user.level == 4 or cur_user.level == 5:
            # 代理商
            agent_today = {}
            agent_today['today_income'] = today_income
            agent_today['today_rent'] = today_rent
            agent_today['yesterday_income'] = yesterday_income
            agent_today['yesterday_rent'] = yesterday_rent
            agent_today['rent_finish'] = rent_finish
            agent_today['rent_not_return'] = rent_not_return
            agent_today['discount'] = today_discount
            if cur_user.level == 2 or cur_user.level == 5:
                agent_today['today_invalid_rent'] = rent_invalid_rent
                agent_today['today_invalid_money'] = rent_invalid_money
            agent_today['spot_info'] = AgentService.get_spot_info(cur_user)
            return jsonify(BASE_RESPONSE(data=agent_today).to_dict())
        else:
            return jsonify(OPERATE_ERROR)


@route_index.route('/machine', methods=['GET', 'POST'])
def machine_info():
    json_data = request.get_json()
    spot_id = json_data['spot_id'] if 'spot_id' in json_data else 0

    data = IndexService.get_machine_info(spot_id)

    return jsonify(BASE_RESPONSE(data=data).to_dict())
