# -*- coding: utf-8 -*-
from sqlalchemy import Index, Column, Integer, Date
from sqlalchemy.ext.declarative import declarative_base

from Model.Base import db

Base = declarative_base()
metadata = Base.metadata


class Dayincome(db.Model):
    __tablename__ = 'dayincome'
    __table_args__ = (
        Index('spot_id_day', 'spot_id', 'day'),
    )

    id = Column(Integer, primary_key=True)
    spot_id = Column(Integer, nullable=False, comment='景区id')
    business_id = Column(Integer, nullable=False, comment='商户id')
    total = Column(Integer, nullable=False, comment='总金额')
    guide_total = Column(Integer, nullable=False, comment='同游共听')
    day = Column(Date, nullable=False, comment='总金额')
