# -*- coding: utf-8 -*-
from sqlalchemy import Column, Integer, FetchedValue, DateTime
from sqlalchemy.ext.declarative import declarative_base

from Model.Base import db

Base = declarative_base()
metadata = Base.metadata


class Settlement(db.Model):
    __tablename__ = 'settlement'

    id = Column(Integer, primary_key=True)
    spot_id = Column(Integer, nullable=False)
    business_id = Column(Integer, nullable=False)
    month = Column(Integer, nullable=False)
    total = Column(Integer, nullable=False)
    guide_total = Column(Integer, nullable=False)
    status = Column(Integer, nullable=False, server_default=FetchedValue())
    bill_id = Column(Integer)
    created_at = Column(DateTime)
    updated_at = Column(DateTime)
