import datetime
import os
from logging import getLogger, DEBUG, StreamHandler, Formatter

from redis import StrictRedis
from Config.common_config import TAKEOUT_RECORD_MAC_NO
from Service.SMSService import SMSService

logger = getLogger(__name__)
logger.setLevel(DEBUG)
console_handler = StreamHandler()
console_handler.setLevel(DEBUG)
formatter = Formatter("%(asctime)s - %(filename)s -[line:%(lineno)d] - %(levelname)s: %(message)s", "%Y-%m-%d %H:%M:%S")
console_handler.setFormatter(formatter)
logger.addHandler(console_handler)

is_prod = os.getenv("RUN_ENV", "test") == 'prod'
# is_prod = True
if is_prod:
    redis = StrictRedis(host='172.17.0.5', port=6379, db=0, password='Boosal2014')
else:
    redis = StrictRedis(host='49.235.36.102', port=16379, db=0, password='Boosal2014')

try:
    for mac_no in TAKEOUT_RECORD_MAC_NO:
        redis_result = redis.get('M_TKO_C_{}'.format(mac_no))
        logger.info(redis_result)
        if redis_result:
            take_out_date, take_out_number = str(redis_result, encoding='utf-8').split('_')
            take_out_number = int(take_out_number)
            today_date = datetime.datetime.now().strftime('%Y-%m-%d')
            if take_out_date == today_date:
                Content = [mac_no, take_out_number]
                phone_number = [18068402080, 15103485838]
                sms = SMSService()
                result = sms.phoneSendCodeWithContent(phone_number, 707999, Content)
                print(result)
except Exception as e:
    logger.info(e)
    exit(1)
