# -*- coding: utf-8 -*-
import time

from flask import Blueprint, jsonify, request

from Libs.ErrorTips import MACHINE_NOT_EXIST_ERROR, MACHINE_HATCH_NOT_ILLEGAL, MACHINE_NOT_ONLINE, BASE_RESPONSE
from Libs.Onenet.Message.Message import CommandMessage
from Libs.Onenet.OneNetApi import OneNetApi
from Model.Base import db
from Model.Machine.MachineModel import Machine
from Model.Power.PowerModel import Power
from Service.ToolService import ToolService

route_tool = Blueprint('tool', __name__)


@route_tool.route('/power_info', methods=['GET', 'POST'])
def get_power_info():
    json_data = request.get_json()
    mac_no = json_data['mac_no'] if 'mac_no' in json_data else None
    if not mac_no:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='illegal mac no').to_dict())

    machine_info = Machine.query.filter_by(mac_no=mac_no).first()
    if not machine_info:
        return jsonify(MACHINE_NOT_EXIST_ERROR)

    data = ToolService.get_power_info_by_machine(machine_info.id)
    return jsonify(BASE_RESPONSE(data=data).to_dict())


@route_tool.route('/takeout', methods=['GET', 'POST'])
def take_out():
    json_data = request.get_json()
    mac_no = json_data['mac_no'] if 'mac_no' in json_data else None
    hatch_no = json_data['hatch_no'] if 'hatch_no' in json_data else None

    if not mac_no or not hatch_no:
        return jsonify(MACHINE_HATCH_NOT_ILLEGAL)

    if hatch_no > 60 or hatch_no < 1:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='mac_no or hatch_no error').to_dict())

    machine_info = Machine.query.filter_by(mac_no=mac_no).first()

    if not machine_info:
        return jsonify(MACHINE_NOT_EXIST_ERROR)

    if machine_info.life != 1:
        return jsonify(MACHINE_NOT_ONLINE)

    command_message = CommandMessage(machine_info.he_cloud_device_id, chr(0x46), str(hatch_no - 1))
    one_api = OneNetApi()

    result = one_api.send_data_to_edp(command_message.get_device_id(), 1, 0, command_message.pack())
    if "errno" in result.keys() and result['errno'] == 0:
        if result['error'] == 'succ':
            return jsonify(BASE_RESPONSE().to_dict())
    else:
        if "error_message" in result.keys():
            return jsonify(BASE_RESPONSE(error_message=result['error_message']).to_dict())
        else:
            return jsonify(BASE_RESPONSE(error_code=-1, error_message='Fail').to_dict())


@route_tool.route('/takeout_multiple', methods=['GET', 'POST'])
def take_out_multiple():
    json_data = request.get_json()
    mac_no = json_data['mac_no'] if 'mac_no' in json_data else None
    hatch_no_list = json_data['hatch_no'] if 'hatch_no' in json_data else []

    if not mac_no or not hatch_no_list:
        return jsonify(MACHINE_HATCH_NOT_ILLEGAL)

    machine_info = Machine.query.filter_by(mac_no=mac_no).first()
    if not machine_info:
        return jsonify(MACHINE_NOT_EXIST_ERROR)

    if machine_info.life != 1:
        return jsonify(MACHINE_NOT_ONLINE)

    data = {}
    for i in hatch_no_list:
        command_message = CommandMessage(machine_info.he_cloud_device_id, chr(0x46), str(i - 1))
        one_api = OneNetApi()
        result = one_api.send_data_to_edp(command_message.get_device_id(), 1, 0, command_message.pack())
        if 'errno' in result.keys() and result['errno'] == 0:
            if result['error'] == 'succ':
                data[i] = 'success'
                Power.query.filter_by(hatch_no=i, machine_id=machine_info.id).update({'status': 8, 'has_power': 0})
                db.session.commit()
            else:
                data[i] = 'fail'
        else:
            if 'error_message' in result.keys():
                data[i] = result['error_message']
            else:
                data[i] = 'fail'
        time.sleep(3)

    return jsonify(BASE_RESPONSE(data=data).to_dict())


@route_tool.route('/reset')
def tool_reset():
    mac_no = request.args.get('mac_no', '')

    if not mac_no:
        return jsonify({'code': -1, 'msg': 'mac no null'})

    machine_info = Machine.query.filter_by(mac_no=mac_no).first()
    if not machine_info:
        return jsonify(MACHINE_NOT_EXIST_ERROR)

    power_info = Power.query.filter_by(machine_id=machine_info.id, status=7).all()

    for power in power_info:
        power.status = 2

    db.session.commit()

    return jsonify(BASE_RESPONSE().to_dict())
