# -*- coding: utf-8 -*-
import datetime
import time

from Libs.Helper import Helper
from Model.Base import db
from Model.Income.DayIncomeModel import Dayincome
from Model.Production.ProductionModel import Production
from Model.Rent.RentModel import Rent
from Model.Settlement.SettlementModel import Settlement
from Service.IndexService import IndexService


class ReportService():
    @staticmethod
    def get_history_rent_number_admin(spot_id, start_time, end_time):
        sql = '''
                SELECT a.hours, a.total_rent, IFNULL(b.valid_rent,0) AS valid_rent, IFNULL(c.invalid_rent,0) AS invalid_rent 
                FROM (SELECT DATE_FORMAT(production.created_at,"%Y-%m-%d") AS hours, COUNT(*) AS total_rent
                FROM production
                WHERE production.is_out = 1 AND production.spot_id = {spot_id} AND production.is_out = 1 
                AND production.created_at >= "{start_time}" 
                AND production.created_at <= "{end_time}" GROUP BY DATE_FORMAT(production.created_at,"%Y-%m-%d")) a
                LEFT JOIN (SELECT DATE_FORMAT(production.created_at,"%Y-%m-%d") AS hours, COUNT(*) AS valid_rent FROM production
                WHERE production.is_out = 1 AND production.is_return = 1 AND production.spot_id = {spot_id}
                AND production.created_at >= "{start_time}" 
                AND production.created_at <= "{end_time}" AND production.total > 0
                GROUP BY DATE_FORMAT(production.created_at,"%Y-%m-%d")) b ON a.hours = b.hours
                LEFT JOIN (SELECT DATE_FORMAT(production.created_at,"%Y-%m-%d") AS hours, COUNT(*) AS invalid_rent FROM production
                WHERE production.is_out = 1 AND production.is_return = 1 AND production.spot_id = {spot_id}
                AND production.created_at >= "{start_time}"
                AND production.created_at <= "{end_time}" AND production.total <= 0
                GROUP BY DATE_FORMAT(production.created_at,"%Y-%m-%d")) c ON a.hours = c.hours
            '''.format(spot_id=spot_id, start_time=start_time, end_time=end_time)
        info = db.session.execute(sql)
        total_data = {}
        my_data = []
        for i in info:
            total_data[str(i.hours)] = {'total_rent': i.total_rent, 'valid_rent': i.valid_rent,
                                        'invalid_rent': i.invalid_rent}
        days = (end_time - start_time).days + 1
        for i in range(days):
            cur_info = {}
            cur_date = datetime.date.today() - datetime.timedelta(days=(days - i))
            cur_info['date'] = cur_date.strftime('%Y-%m-%d')
            cur_info['total_rent'] = total_data[str(cur_date.strftime('%Y-%m-%d'))]['total_rent'] if str(
                cur_date.strftime('%Y-%m-%d')) in total_data.keys() else 0
            cur_info['valid_rent'] = total_data[str(cur_date.strftime('%Y-%m-%d'))]['valid_rent'] if str(
                cur_date.strftime('%Y-%m-%d')) in total_data.keys() else 0
            cur_info['invalid_rent'] = total_data[str(cur_date.strftime('%Y-%m-%d'))]['invalid_rent'] if str(
                cur_date.strftime('%Y-%m-%d')) in total_data.keys() else 0

            my_data.append(cur_info)

        return my_data

    @staticmethod
    def get_history_rent_number_agent(spot_id, start_time, end_time):
        sql = '''
            SELECT DATE_FORMAT(production.created_at,"%Y-%m-%d") AS hours, COUNT(*) AS total_rent
            FROM production
            WHERE production.is_out = 1 AND production.spot_id = {spot_id} AND production.is_out = 1 
            AND production.created_at >= "{start_time}" 
            AND production.created_at <= "{end_time}" GROUP BY DATE_FORMAT(production.created_at,"%Y-%m-%d")
        '''.format(spot_id=spot_id, start_time=start_time, end_time=end_time)
        info = db.session.execute(sql)
        total_data = {}
        my_data = []
        for i in info:
            total_data[str(i.hours)] = {'total_rent': i.total_rent}

        days = (end_time - start_time).days + 1
        for i in range(days):
            cur_info = {}
            cur_date = datetime.date.today() - datetime.timedelta(days=(days - i))
            cur_info['date'] = cur_date.strftime('%Y-%m-%d')
            cur_info['total_rent'] = total_data[str(cur_date.strftime('%Y-%m-%d'))]['total_rent'] if str(
                cur_date.strftime('%Y-%m-%d')) in total_data.keys() else 0
            my_data.append(cur_info)
        return my_data

    @staticmethod
    def get_today_rent_number_admin(spot_id):
        start_time, end_time = Helper.getTodayDate()
        sql = '''
                SELECT a.hours, a.total_rent, IFNULL(b.valid_rent,0) AS valid_rent, IFNULL(c.invalid_rent, 0) AS invalid_rent FROM 
                (SELECT DATE_FORMAT(production.created_at,"%H") AS hours, COUNT(*) AS total_rent FROM production
                WHERE production.spot_id = {spot_id} AND production.is_out = 1 AND production.created_at >= "{start_time}" 
                AND production.created_at <= "{end_time}" GROUP BY DATE_FORMAT(production.created_at,"%H")) a 
                LEFT JOIN (SELECT DATE_FORMAT(production.created_at,"%H") AS hours, COUNT(*) AS valid_rent FROM production
                WHERE production.is_out = 1 AND production.is_return = 1 AND production.spot_id = {spot_id} AND production.created_at >= "{start_time}" 
                AND production.created_at <= "{end_time}" AND production.total > 0
                GROUP BY DATE_FORMAT(production.created_at,"%H")) b ON a.hours = b.hours 
                LEFT JOIN  (SELECT DATE_FORMAT(production.created_at,"%H") AS hours, COUNT(*) AS invalid_rent FROM production
                WHERE production.is_out = 1 AND production.is_return = 1 AND production.spot_id = {spot_id} AND production.created_at >= "{start_time}"
                AND production.created_at <= "{end_time}" AND production.total <= 0
                GROUP BY DATE_FORMAT(production.created_at,"%H")) c ON a.hours = c.hours
            '''.format(spot_id=spot_id, start_time=start_time, end_time=end_time)
        info = db.session.execute(sql)
        total_data = {}
        my_data = []
        for i in info:
            total_data[int(i.hours)] = {'total_rent': i.total_rent, 'valid_rent': i.valid_rent,
                                        'invalid_rent': i.invalid_rent}

        for i in range(24):
            cur_info = {}
            cur_info['hour'] = i
            cur_info['total_rent'] = total_data[i]['total_rent'] if i in total_data.keys() else 0
            cur_info['valid_rent'] = total_data[i]['valid_rent'] if i in total_data.keys() else 0
            cur_info['invalid_rent'] = total_data[i]['invalid_rent'] if i in total_data.keys() else 0
            my_data.append(cur_info)
        return my_data

    @staticmethod
    def get_today_rent_number_agent(spot_id):
        start_time, end_time = Helper.getTodayDate()
        sql = '''
                SELECT DATE_FORMAT(production.created_at,"%H") AS hours, COUNT(*) AS total_rent FROM production
                WHERE production.spot_id = {spot_id} AND production.is_out = 1 AND production.created_at >= "{start_time}" 
                AND production.created_at <= "{end_time}" GROUP BY DATE_FORMAT(production.created_at,"%H")
            '''.format(spot_id=spot_id, start_time=start_time, end_time=end_time)
        info = db.session.execute(sql)
        total_data = {}
        my_data = []
        for i in info:
            total_data[int(i.hours)] = {'total_rent': i.total_rent}

        for i in range(24):
            cur_info = {}
            cur_info['hour'] = i
            cur_info['total_rent'] = total_data[i]['total_rent'] if i in total_data.keys() else 0
            my_data.append(cur_info)
        return my_data

    @staticmethod
    def get_customer_rent_number(spot_id):
        rent_number = Rent.query.with_entities(Rent.number).filter(Rent.spot_id == spot_id).all()
        number_one = 0
        number_two = 0
        number_three = 0
        for i in rent_number:
            if i.number == 1:
                number_one += 1
            elif i.number == 2:
                number_two += 1
            elif i.number == 3:
                number_three += 1

        return {'one': number_one, 'two': number_two, 'three': number_three}

    @staticmethod
    def get_customer_rent_time(spot_id):
        rent_info = db.session.query(Production, Rent).join(Rent, Rent.id == Production.rent_id).filter(
            Production.spot_id == spot_id, Rent.spot_id == spot_id).all()
        less_one = 0
        larger_two = 0
        one_two = 0
        for info in rent_info:
            if info.Production.return_time is None or info.Rent.pay_time is None:
                continue

            use_time = Helper.checkTime(info.Rent.pay_time, info.Production.return_time)
            if use_time < 60:
                less_one += 1
            elif use_time > 120:
                larger_two += 1
            else:
                one_two += 1

        return {'less_one': less_one, 'larger_two': larger_two, 'one_two': one_two}

    @staticmethod
    def get_spot_day_income(spot_id, start_time, end_time, days):
        where = {
            Dayincome.spot_id == spot_id,
            Dayincome.day >= start_time,
            Dayincome.day <= end_time
        }
        day_income_info = Dayincome.query.filter(*where).all()
        data = {}
        for info in day_income_info:
            data[info.day.strftime('%Y-%m-%d')] = info.total

        new_data = []
        for i in range(days):
            tmp = {}
            now = datetime.datetime.now() - datetime.timedelta(days=(days - i))
            now = now.strftime('%Y-%m-%d')
            tmp['day'] = now
            if now in data:
                tmp['total'] = round(data[now] / 100, 2)
            else:
                tmp['total'] = 0
            new_data.append(tmp)

        return new_data

    @staticmethod
    def get_spot_month_income(spot_id, start_time, end_time):
        where = {
            Settlement.spot_id == spot_id,
            Settlement.month >= start_time,
            Settlement.month <= end_time
        }
        month_income_info = Settlement.query.filter(*where).all()
        data = []
        for info in month_income_info:
            tmp = {
                'month': info.month,
                'total': round(info.total / 100, 2)
            }
            data.append(tmp)
        return data

    @staticmethod
    def get_spot_rent_record(spot_id, data_type, date, page, limit):
        where = {
            Rent.is_over == 1,
            Rent.spot_id == spot_id,
        }
        income = 0
        if data_type == 1:
            where.add(Rent.created_at >= date + ' 00:00:00')
            where.add(Rent.created_at <= date + ' 23:59:59')
            income, total = IndexService.get_total_production(spot_id, date + ' 00:00:00', date + ' 23:59:59')
        else:
            last_date = Helper.get_this_month_day(date)
            if last_date:
                where.add(Rent.created_at >= date + '-01 00:00:00')
                where.add(Rent.created_at <= date + last_date)
                income, total = IndexService.get_total_production(spot_id, date + '-01 00:00:00', date + last_date)

        rent_info = Rent.query.filter(*where).order_by(Rent.created_at.desc()).slice(page * limit,
                                                                                     (page + 1) * limit).all()
        data = []
        for info in rent_info:
            cur_total = round(info.real_total / 100, 2)
            tmp = {
                'real_total': cur_total,
                'over_time': Helper.getFormatDate(info.created_at)
            }
            data.append(tmp)

        return income, data
