# -*- coding: utf-8 -*-

from flask import Blueprint, request, jsonify, g

from Libs.ErrorTips import BASE_RESPONSE
from Libs.Helper.Helper import getFormatDate

from Model.Base import db
from Model.Customer.CustomerModel import Customer
from Model.Production.ProductionModel import Production
from Model.Rent.RentModel import Rent
from Model.invoice.InvoiceModel import Invoice
from Model.invoice.InvoiceRecoreModel import InvoiceRecord
from Service.InvoiceService import InvoiceService

route_invoice = Blueprint('invoice', __name__)


@route_invoice.route('/list')
def invoice_list():
    if g.user.id not in (2, 4):
    # if g.user.id != 4:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='permission denied').to_dict())

    invoice_info = InvoiceRecord.query.filter(InvoiceRecord.status == 1, InvoiceRecord.parent_id > 0).all()
    data = []
    for info in invoice_info:
        customer_info = Customer.query.filter_by(id=info.customer_id).first()
        phone = customer_info.phone if customer_info else None
        tmp = {
            'invoice_id': info.id,
            'data': getFormatDate(info.created_at),
            'total': info.pay_money,
            'status': info.status,
            'phone': phone
        }
        data.append(tmp)
    return jsonify(BASE_RESPONSE(data=data).to_dict())


@route_invoice.route('/verify', methods=['GET', 'POST'])
def invoice_compare():
    if g.user.id not in (2, 4):
    # if g.user.id != 4:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='permission denied').to_dict())

    json_data = request.get_json()
    invoice_id = json_data['invoice_id'] if 'invoice_id' in json_data else 0
    if int(invoice_id) < 1:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='invoice id error').to_dict())

    new_invoice_info = InvoiceRecord.query.filter_by(id=invoice_id).first()
    if not new_invoice_info:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='error').to_dict())

    if new_invoice_info.parent_id == 0:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='该发票没有重开过').to_dict())

    old_invoice_info = InvoiceRecord.query.filter_by(id=new_invoice_info.parent_id).first()
    if not old_invoice_info:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='error').to_dict())

    customer_info = Customer.query.filter_by(id=new_invoice_info.customer_id).first()
    phone = customer_info.phone if customer_info else None

    new_rent_list = new_invoice_info.rent_list.split(",")
    new_info = {
        "company_name": new_invoice_info.company_name,
        "payment_id": new_invoice_info.payment_id,
        "e_account": new_invoice_info.e_account,
        "remark": new_invoice_info.remark,
        "address": new_invoice_info.address,
        "account": new_invoice_info.account,
        "rent_count": len(new_rent_list),
        "apply_time": getFormatDate(new_invoice_info.created_at),
        "phone": phone
    }

    old_rent_list = old_invoice_info.rent_list.split(",")
    old_info = {
        "company_name": old_invoice_info.company_name,
        "payment_id": old_invoice_info.payment_id,
        "e_account": old_invoice_info.e_account,
        "remark": old_invoice_info.remark,
        "address": old_invoice_info.address,
        "account": old_invoice_info.account,
        "rent_count": len(old_rent_list),
        "apply_time": getFormatDate(old_invoice_info.created_at),
        "phone": phone
    }

    return jsonify(BASE_RESPONSE(data={'new_info': new_info, 'old_info': old_info}).to_dict())


@route_invoice.route('/submit', methods=['GET', 'POST'])
def invoice_submit():
    if g.user.id not in (2, 4):
    # if g.user.id != 4:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='permission denied').to_dict())

    json_data = request.get_json()
    invoice_id = json_data['invoice_id'] if 'invoice_id' in json_data else None
    invoice_type = json_data['type'] if 'type' in json_data else None  # 1:同意 2:驳回 3:拒绝
    reason = json_data['reason'] if 'reason' in json_data else None  # 理由

    if not invoice_id or not type:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='params error').to_dict())

    if int(invoice_id) < 1:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='invoice id error').to_dict())

    current_invoice = InvoiceRecord.query.filter_by(id=invoice_id).first()
    if not current_invoice:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='no such invoice').to_dict())

    parent_id = current_invoice.parent_id
    if parent_id == 0:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='该发票未重开过').to_dict())

    invoice_detail = db.session.query(Invoice, InvoiceRecord).outerjoin(InvoiceRecord,
                                                                        Invoice.id == InvoiceRecord.invoice_id).filter(
        InvoiceRecord.id == parent_id).first()

    if int(invoice_type) == 1:
        # 审核成功
        invoice_info = InvoiceService()
        # 红冲
        red_result = invoice_info.red_rush(invoice_detail.Invoice.fp_dm, invoice_detail.Invoice.fp_hm)
        gmf_mc = current_invoice.company_name
        gmf_nsrsbh = current_invoice.payment_id
        gmf_dzyx = current_invoice.e_account
        address = current_invoice.address
        account = current_invoice.account
        remark = current_invoice.remark
        rent_list = current_invoice.rent_list

        # 重开发票
        repeat_result, new_id = invoice_info.dict_content(gmf_mc, gmf_nsrsbh, gmf_dzyx, address, account, remark,
                                                          rent_list)
        if new_id != 0:
            new_info = Invoice.query.filter_by(id=new_id).first()
            new_info.is_red = 2
            db.session.add(new_info)

        current_invoice.status = 2
        current_invoice.invoice_id = new_id
        db.session.add(current_invoice)
        db.session.commit()

        data = {
            'red_result': red_result,
            'repeat_result': repeat_result
        }

        return jsonify(BASE_RESPONSE(data=data).to_dict())
    elif int(invoice_type) == 2:
        # 驳回
        current_invoice.status = 3
        current_invoice.reason = reason
        db.session.add(current_invoice)
        db.session.commit()
        return jsonify(BASE_RESPONSE().to_dict())
    else:
        # 拒绝
        current_invoice.status = 4
        current_invoice.reason = reason
        db.session.add(current_invoice)
        db.session.commit()
        return jsonify(BASE_RESPONSE().to_dict())


@route_invoice.route('/rent_list', methods=['GET', 'POST'])
def invoice_rent():
    if g.user.id not in (2, 4):
    # if g.user.id != 4:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='permission denied').to_dict())

    json_data = request.get_json()
    invoice_id = json_data['invoice_id'] if 'invoice_id' in json_data else 0
    if int(invoice_id) < 1:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='invoice id error').to_dict())

    invoice_info = InvoiceRecord.query.filter_by(id=invoice_id).first()
    if not invoice_info:
        return jsonify(BASE_RESPONSE(error_code=-1, error_message='no invoice info').to_dict())

    data = []
    rent_all = invoice_info.rent_list
    rent_all_list = rent_all.split(",")

    for info in rent_all_list:
        cur_info = db.session.query(Rent, Production).join(Production, Production.rent_id == Rent.id).filter(
            Rent.rent_no == info).first()

        tmp = {}
        tmp["rent_no"] = cur_info.Rent.rent_no
        tmp["hatch_no"] = cur_info.Production.rent_hatch_no
        tmp["total"] = 0 if cur_info.Production.total is None else cur_info.Production.total
        if cur_info.Production.is_return == 1:
            if tmp["total"] <= 0:
                if cur_info.Production.return_hatch_no == 127:
                    tmp["status"] = 3
                else:
                    tmp["status"] = 2
            else:
                tmp["status"] = 1
        else:
            tmp["status"] = 0

        data.append(tmp)

    return jsonify(BASE_RESPONSE(data=data).to_dict())
