# -*- coding: utf-8 -*-
from sqlalchemy import Column, Integer, String
from sqlalchemy.ext.declarative import declarative_base
from Model.Base import db, BaseModel

Base = declarative_base()
metadata = Base.metadata


class DaySaleCountModel(BaseModel):
    __tablename__ = 'day_sale_count'

    id = Column(Integer, primary_key=True, comment="")
    check_sum = Column(Integer, nullable=False, comment="预约上限人数")
    total_sum = Column(Integer, nullable=False, comment="已预约人数")
    week_check_sum = Column(Integer, nullable=False, comment="=本周预约人数")
    lastweek_check_sum = Column(Integer, nullable=False, comment="上周预约人数")
    today = Column(db.DateTime, nullable=False, comment="数据日期")


class DayBookCountModel(BaseModel):
    __tablename__ = 'day_book_count'

    id = Column(Integer, primary_key=True)
    spot_id = Column(Integer, nullable=False)
    spot_name = Column(String(40, 'utf8mb4_unicode_ci'), nullable=False)
    fixed_total_num = Column(Integer, nullable=False, comment="预约上限人数")
    fixed_usable_num = Column(Integer, nullable=False, comment="预约人数")
    individual_limit = Column(Integer, nullable=False, comment="")
    team_total_num = Column(Integer, nullable=False, comment="")
    team_usable_num = Column(Integer, nullable=False, comment="")
    total_num = Column(Integer, nullable=False, comment="预约上限人数")
    usable_num = Column(Integer, nullable=False, comment="可预约人数")
    today = Column(db.DateTime, nullable=False, comment="数据日期")


class DayVisitorCountModel(BaseModel):
    __tablename__ = 'day_visitor_count'

    id = Column(Integer, primary_key=True, comment="")
    spot_id = Column(Integer, nullable=False, comment="")
    spot_name = Column(String(40, 'utf8mb4_unicode_ci'), nullable=False, comment="")
    foot_num = Column(Integer, nullable=False, comment="在园人数")
    foreigner_num = Column(Integer, nullable=False, comment="")
    free_num = Column(Integer, nullable=False, comment="")
    left_num = Column(Integer, nullable=False, comment="已入园人数")
    limit_num = Column(Integer, nullable=False, comment="当日人数上限")
    old_num = Column(Integer, nullable=False, comment="")
    total_num = Column(Integer, nullable=False, comment="当日售票人数")
    today = Column(db.DateTime, nullable=False, comment="数据日期")


class DaySZMuseumVisitorCountModel(BaseModel):
    __tablename__ = 'day_sz_museum_visitor_count'

    id = Column(Integer, primary_key=True, comment="")
    spot_id = Column(Integer, nullable=False, comment="")
    spot_name = Column(String(40, 'utf8mb4_unicode_ci'), nullable=False, comment="")
    total_count = Column(Integer, nullable=False, comment="总接待数")
    current_count = Column(Integer, nullable=False, comment="在园人数")
    incount1 = Column(Integer, nullable=False, comment="")
    incount2 = Column(Integer, nullable=False, comment="")
    outcount1 = Column(Integer, nullable=False, comment="")
    outcount2 = Column(Integer, nullable=False, comment="出园人数")
    today = Column(db.DateTime, nullable=False, comment="数据日期")
