# -*- coding: utf-8 -*-
import base64
import datetime
import hashlib
import json

import random

import requests
from Crypto.Cipher import AES

from Config.common_config import INVOICE_CONFIG
from Model.Base import db
from Model.Rent.RentModel import Rent
from Model.invoice.InvoiceModel import Invoice


class InvoiceService:
    def __init__(self):
        self.url = INVOICE_CONFIG["url"]
        self.app_id = INVOICE_CONFIG["app_id"]
        self.key = INVOICE_CONFIG["app_key"]
        self.xsf_nsrsbh = INVOICE_CONFIG["xsf_nsrsbh"]

    @classmethod
    def encrypt(cls, raw, key):
        block_size = 16  # Bytes
        raw = raw + (block_size - len(raw) % block_size) * chr(block_size - len(raw) % block_size)
        cipher = AES.new(str.encode(key), AES.MODE_ECB)
        return base64.b64encode(cipher.encrypt(str.encode(raw))).decode(encoding='utf-8')

    @classmethod
    def create_fpqqlsh(cls):
        data_str = datetime.datetime.now().strftime('%Y%m%d')
        int_str = str(random.randint(1, 9999)).zfill(7)
        return 'SZSSW' + data_str + int_str

    def dict_content(self, gmf_mc, gmf_nsrsbh, gmf_dzyx, gmf_dzdh, gmf_yhzh, remark, rent_list):
        new_list = rent_list.split(',')
        common_fpkj_xmxx = []
        jshj = 0
        hjje_total = 0
        hjsh = 0
        for ls in new_list:
            rent_info = Rent.query.filter_by(rent_no=ls).first()
            real_total = round(rent_info.real_total / 100, 2)
            xmdj = str(round(real_total / 1.06, 11))
            xmje = str(round(real_total / 1.06, 2))
            se = str(round((real_total - round(real_total / 1.06, 2)), 2))
            jshj += real_total
            hjje_total += round(real_total / 1.06, 2)
            hjsh += round(real_total - round(real_total / 1.06, 2), 2)
            # "SPBM": "304020300000000000001"
            tmp = {
                "FPHXZ": "0",
                "SPBM": INVOICE_CONFIG["spbm"],
                "ZXBM": "",
                "YHZCBS": "",
                "LSLBS": "",
                "ZZSTSGL": "",
                "XMMC": "信息技术服务",
                "GGXH": "",
                "DW": "",
                "XMSL": "1",
                "XMDJ": xmdj,
                "XMJE": xmje,
                "SL": "0.06",
                "SE": se,
                "BY1": "",
                "BY2": "",
                "BY3": "",
                "BY4": "",
                "BY5": "",
            }
            common_fpkj_xmxx.append(tmp)

        dict_content = {"REQUEST_COMMON_FPKJ": {"FPQQLSH": self.create_fpqqlsh(),
                                                "BMB_BBH": "",
                                                "ZSFS": "0",
                                                "KPLX": "0",
                                                "XSF_NSRSBH": self.xsf_nsrsbh,
                                                "XSF_MC": INVOICE_CONFIG["xsf_mc"],
                                                "XSF_DZDH": INVOICE_CONFIG["dizhi_dianhua"],
                                                "XSF_YHZH": INVOICE_CONFIG["yinhang_zhanghao"],
                                                "GMF_NSRSBH": gmf_nsrsbh,
                                                "GMF_MC": gmf_mc,
                                                "GMF_DZDH": gmf_dzdh,
                                                "GMF_YHZH": gmf_yhzh,
                                                "GMF_SJH": "18068402080",
                                                "GMF_DZYX": gmf_dzyx,
                                                "FPT_ZH": "",
                                                "WX_OPENID": "",
                                                "KPR": INVOICE_CONFIG["kaipiaoren"],
                                                "SKR": INVOICE_CONFIG["shoukuanren"],
                                                "FHR": INVOICE_CONFIG["fuheren"],
                                                "YFP_DM": "",
                                                "YFP_HM": "",
                                                "JSHJ": jshj,
                                                "HJJE": hjje_total,
                                                "HJSE": hjsh,
                                                "KCE": "",
                                                "BZ": remark,
                                                "HYLX": "0",
                                                "BY1": "",
                                                "BY2": "",
                                                "BY3": "",
                                                "BY4": "",
                                                "BY5": "",
                                                "BY6": "",
                                                "BY7": "",
                                                "BY8": "",
                                                "BY9": "",
                                                "BY10": "",
                                                "WX_ORDER_ID": "",
                                                "WX_APP_ID": "",
                                                "ZFB_UID": "",
                                                "TSPZ": "00",
                                                "QJ_ORDER_ID": "",
                                                "WX_GROUP_ID": "",
                                                "COMMON_FPKJ_XMXXS": {"COMMON_FPKJ_XMXX": common_fpkj_xmxx}}}
        json_content = json.dumps(dict_content)

        # BASE64加密并转成字符串
        content = base64.b64encode(json_content.encode('utf-8')).decode(encoding='utf-8')
        # 对content进行md5
        contentMd5 = hashlib.md5(content.encode("utf-8")).hexdigest()
        # 对md5进行aes加密
        contentKey = self.encrypt(contentMd5, self.key)

        post_data = {
            "interface": {
                "globalInfo": {
                    "appId": self.app_id,
                    "interfaceId": "",
                    "interfaceCode": "DFXJ1001",
                    "requestCode": "DS",
                    "requestTime": "2017-02-14 08:13:15",
                    "responseCode": "DZFPQZ",
                    "dataExchangeId": "DZFPQZDFXJ10012017-02-14128641426"
                },
                "returnStateInfo": {
                    "returnCode": "",
                    "returnMessage": ""
                },
                "Data": {
                    "dataDescription": {
                        "zipCode": "0"
                    },
                    "content": content,
                    "contentKey": contentKey
                }}
        }
        post_data = json.dumps(post_data)

        cert_path = INVOICE_CONFIG["cert_path"]

        res = requests.post(self.url, data=post_data, cert=cert_path)
        if not res.text:
            return {"error_code": -1, "error_message": "申请失败，请重新申请！"}, 0

        res = json.loads(res.text)

        if res['interface']['returnStateInfo']['returnCode'] != "0000":
            return res['interface']['returnStateInfo'], 0

        raw = res["interface"]["Data"]["content"]

        raw = str(base64.b64decode(raw), encoding="utf-8")

        new_invoice = Invoice()
        if raw:
            raw = json.loads(raw)
            new_invoice.fpqqlsh = raw['FPQQLSH']
            new_invoice.fp_dm = raw['FP_DM']
            new_invoice.fp_hm = raw['FP_HM']
            new_invoice.kprq = raw['KPRQ']
            new_invoice.jym = raw['JYM']
            new_invoice.pdf_url = raw['PDF_URL']
            new_invoice.sp_url = raw['SP_URL']
            new_invoice.status = 1
            new_invoice.is_red = 0
            new_invoice.created_at = datetime.datetime.now()
            new_invoice.updated_at = datetime.datetime.now()

            db.session.add(new_invoice)
            db.session.commit()

        return raw, new_invoice.id

    def red_rush(self, yfp_dm, yfp_hm):
        dict_content = {
            "REQUEST_COMMON_FPKSHC": {
                "FPQQLSH": self.create_fpqqlsh(),
                "XSF_NSRSBH": INVOICE_CONFIG["xsf_nsrsbh"],
                "XSF_MC": INVOICE_CONFIG["xsf_mc"],
                "YFP_DM": yfp_dm,
                "YFP_HM": yfp_hm
            }
        }
        json_content = json.dumps(dict_content)

        # BASE64加密并转成字符串
        content = base64.b64encode(json_content.encode('utf-8')).decode(encoding='utf-8')
        # 对content进行md5
        contentMd5 = hashlib.md5(content.encode("utf-8")).hexdigest()
        # 对md5进行aes加密
        contentKey = self.encrypt(contentMd5, self.key)

        post_data = {
            "interface": {
                "globalInfo": {
                    "appId": self.app_id,
                    "interfaceId": "",
                    "interfaceCode": "DFXJ1008",
                    "requestCode": "DS",
                    "requestTime": "2017-02-14 08:13:15",
                    "responseCode": "DZFPQZ",
                    "dataExchangeId": "DZFPQZDFXJ10012017-02-14128641426"
                },
                "returnStateInfo": {
                    "returnCode": "",
                    "returnMessage": ""
                },
                "Data": {
                    "dataDescription": {
                        "zipCode": "0"
                    },
                    "content": content,
                    "contentKey": contentKey
                }}
        }

        post_data = json.dumps(post_data)

        cert_path = INVOICE_CONFIG["cert_path"]

        res = requests.post(self.url, data=post_data, cert=cert_path)
        if not res.text:
            return {"error_code": -1, "error_message": "申请失败，请重新申请！"}, 0

        res = json.loads(res.text)

        if res['interface']['returnStateInfo']['returnCode'] != "0000":
            return res['interface']['returnStateInfo']

        raw = res["interface"]["Data"]["content"]

        raw = str(base64.b64decode(raw), encoding="utf-8")

        new_invoice = Invoice()
        if raw:
            raw = json.loads(raw)
            new_invoice.fpqqlsh = raw['FPQQLSH']
            new_invoice.fp_dm = raw['FP_DM']
            new_invoice.fp_hm = raw['FP_HM']
            new_invoice.kprq = raw['KPRQ']
            new_invoice.jym = raw['JYM']
            new_invoice.pdf_url = raw['PDF_URL']
            new_invoice.sp_url = raw['SP_URL']
            new_invoice.status = 1
            new_invoice.is_red = 1
            new_invoice.created_at = datetime.datetime.now()
            new_invoice.updated_at = datetime.datetime.now()

            db.session.add(new_invoice)
            db.session.commit()

        return raw
