# -*- coding: utf-8 -*-
from sqlalchemy import Column, Integer, FetchedValue, String

from sqlalchemy.sql.sqltypes import NullType

from Model.Base import BaseModel


class Machine(BaseModel):
    __tablename__ = 'machine'

    id = Column(Integer, primary_key=True)
    mac_no = Column(String(16, 'utf8mb4_unicode_ci'), nullable=False, comment='机柜编号')
    he_cloud_device_id = Column(String(191, 'utf8mb4_unicode_ci'), nullable=False, comment='机柜号对应的波所的编号')
    one_day_price = Column(Integer, nullable=False, comment='日租金')
    price_type = Column(Integer, nullable=False, comment='收费类型  1:按天收费   2:按时收费')
    deposit = Column(Integer, nullable=False, server_default=FetchedValue(), comment='押金')
    free_time = Column(Integer, nullable=False, server_default=FetchedValue(), comment='免费时间')
    position = Column(NullType, comment='机柜位置坐标')
    address = Column(String(191, 'utf8mb4_unicode_ci'), comment='机柜位置')
    spot_id = Column(Integer, nullable=False)
    business_id = Column(Integer, nullable=False)
    wx_mini_program = Column(String(191, 'utf8mb4_unicode_ci'), nullable=False, comment='微信租借二维码地址')
    ali_mini_program = Column(String(191, 'utf8mb4_unicode_ci'), nullable=False, comment='支付宝租借二维码地址')
    version = Column(String(191, 'utf8mb4_unicode_ci'), comment='版本号')
    iccid = Column(String(191, 'utf8mb4_unicode_ci'), comment='iccid')
    life = Column(Integer, nullable=False, server_default=FetchedValue(), comment='机柜在线状态默认0不在线1在线')
    type = Column(Integer, nullable=False, comment='机柜类型')
    hatch_number = Column(Integer, nullable=False, server_default=FetchedValue(), comment='机柜的仓口数量')
    take_out_tool = Column(Integer, nullable=False, comment='0:没有弹出功能 ， 1：有')
