const app = getApp();
Page({
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    index1: "tap_active",
    index2: "",
    transRecordList:[],
    separateList:[],
    start_time:"请选择开始时间",
    end_time: "请选择结束时间",
  },
  onShow: function () {
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
    this.getAll();
  },
  getAll:function(){
    this.getTransRecordList();
    this.getSeparateList();
  },
  getTransRecordList:function(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_trans_record_list",
        start_time: PageThis.data.start_time == "请选择开始时间" ? "" : PageThis.data.start_time,
        end_time: PageThis.data.end_time == "请选择结束时间" ? "" : PageThis.data.end_time,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(res){
        var data = res.data.data;
        PageThis.setData({
          transRecordList: data
        })
      }
    })
  },
  getSeparateList:function(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_separate_list",
        start_time: PageThis.data.start_time == "请选择开始时间" ? "" : PageThis.data.start_time,
        end_time: PageThis.data.end_time == "请选择结束时间" ? "" : PageThis.data.end_time,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success: function (res) {
        var data = res.data.data;
        PageThis.setData({
          separateList: data
        })
      }
    })
  },
  
  switchTap:function(e){
    var PageThis = this;
    var index = e.currentTarget.dataset.index;
    if(index == 1){
      PageThis.setData({
        index1: "tap_active",
        index2: "",
      })
    }else if(index == 2){
      PageThis.setData({
        index1: "",
        index2: "tap_active",
      })
    }
  },
  pickerChange: function (e) {
    var PageThis = this;
    var val = e.detail.value;
    var name = e.target.dataset.name;
    switch (name) {
      case "start_time":
        PageThis.setData({
          start_time: val
        })
        break;
      case "end_time":
        PageThis.setData({
          end_time: val
        })
        break;
    }
  }
})