// pages/cardList/index.js
const app = getApp();
Page({
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    search_value:"",
    cardList : []
  },
  onShow: function () {
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
    this.getCardList();
  },
  //**页面跳转 */
  navigateTo: function (e) {
    var _url = e.currentTarget.dataset.url;
    var _id = e.currentTarget.dataset.id;
    wx.navigateTo({
      url: _url + "?id=" + _id,
    })
  },
  getCardList:function(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_bank_card",
        keywords: PageThis.data.search_value,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(res){
        res = res.data;
        if(res.state == 1){
          PageThis.setData({
            cardList:res.data
          })
        }
      }
    })
  }
})