// pages/changePassword/index.js
const app = getApp();
Page({
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    submitData:{
      oldPassword: "",
      newPassword: "",
      rePassword: "",
    }
  },
  onLoad(){
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
  },
  inputChange: function (e) {
    var PageThis = this;
    var name = e.currentTarget.dataset.name;
    var data = PageThis.data.submitData;
    data[name] = e.detail.value;
    PageThis.setData({
      "submitData": data
    })
  },
  sureSubmit:function(){
    var PageThis = this;
    var data = PageThis.data.submitData;
    data['api_name'] = "update_manager_password";
    data['login_manager_id'] = PageThis.data.userInfo.manager_id
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: data,
      success:function(res){
        res = res.data;
        if (res.state == 1){
          wx.showToast({
            title: "修改成功",
            icon: "success",
            duration: 1500
          })
          setTimeout(function(){
            try {
              wx.removeStorageSync('userInfo');
              wx.removeStorage({ key: 'userInfo' });
              wx.reLaunch({
                url: '../login/index',
              })
            } catch (e) { }
          },1500);
        }else{
          wx.showToast({
            title: res.msg,
            icon:"none",
            duration: 2000
          })
        }
      }
    })
  }
})