// pages/createRepair/index.js
const app = getApp();
Page({
  data: {
    userInfo: {},
    deviceList: [],
    deliveryInfo:{
      pay_method:2,
      delivery_company:"",
      delivery_number:"",
      receive_back_address:""
    },
    sendTypeValue:2,
    paymentTypeValue:2,
    sendTypeList:[
      {
        "name":"自取",
        "value":1,
        "checked":false
      },
      {
        "name":"快递",
        "value":2,
        "checked":true
      }
    ],
    paymentTypeList:[
      {
        "name":"到付",
        "value":1,
        "checked":false
      },
      {
        "name":"寄付",
        "value":2,
        "checked":true
      }
    ]
  },
  onLoad: function (options) {
    this.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
  },
  radioChange(e){
    var PageThis = this;
    var goodsInfo = PageThis.data.goodsInfo;
    goodsInfo['g_money_type'] = e.detail.value;
    PageThis.setData({
      "goodsInfo":goodsInfo
    })
  },
  quickScan(){
    var PageThis = this;
    wx.scanCode({
      scanType:"qrCode",
      success (res) {
        var scan_url = res.result;
        var thisDevNo = scan_url.replace(app.globalData.serverInfo.qrReplaceUrl, '');
        if(thisDevNo != "" ){
          var deviceList = PageThis.data.deviceList;
          for(var i in deviceList){
            if(deviceList[i].dev_no == thisDevNo){
              wx.showToast({
                title: '此设备已记录',
                icon: 'none'
              })
              return;
            }
          }
          var obj = {
            dev_no:thisDevNo,
            repair_content:{
              'reason':""
            }
          }
          deviceList.unshift(obj);
          PageThis.setData({
            deviceList:deviceList
          })
        }else{
          wx.showToast({
            title: '无效二维码',
            icon:"none"
          })
        }
      }
    })
  },
  inputChange:function(e){
    var PageThis = this;
    var name = e.currentTarget.dataset.name;
    var code = e.currentTarget.dataset.code;
    var val = e.detail.value;
    var devList = PageThis.data.deviceList;
    var deliveryInfo = PageThis.data.deliveryInfo;
    console.log(e);
    switch(name){
      case "delivery_company":
      case "delivery_number":
      case "receive_back_address":
        deliveryInfo[name] = val;
        PageThis.setData({
          deliveryInfo:deliveryInfo
        })
        break;
      // case "errro_detail":
      //   console.log(devList);
      //   for(var i in devList){
      //     if(devList[i].dev_no == code){
      //       devList[i].repair_content.reason = val;
      //       break;
      //     }
      //   }
      //   PageThis.setData({
      //     deviceList:devList
      //   })
      //   break;
    }
  },
  radioChange(e){
    var PageThis = this;
    var name = e.currentTarget.dataset.name;
    var val = e.detail.value;
    var deliveryInfo = PageThis.data.deliveryInfo;
    switch(name){
      case "repair_delivery_type":
        PageThis.setData({
          sendTypeValue:val
        })
        break;
      case "pay_method":
        deliveryInfo[name] = val;
        PageThis.setData({
          deliveryInfo:deliveryInfo,
          paymentTypeValue:val
        })
        break;
    }
  },
  del_dev(e){
    var PageThis = this;
    var code = e.currentTarget.dataset.code;
    var devList = PageThis.data.deviceList;
    for(var i in devList){
      if(devList[i].dev_no == code){
        devList.splice(i,1);
        break;
      }
    }
    PageThis.setData({
      deviceList:devList
    })
  },
  applyRepair(e){
    var PageThis = this;
    var repair_delivery_type = PageThis.data.sendTypeValue;
    var dev_list = PageThis.data.deviceList;
    var repair_delivery_content = PageThis.data.deliveryInfo;
    var value = e.detail.value;
    if(dev_list.length <= 0){
      wx.showToast({
        title: '无故障设备信息',
        icon:"none"
      })
      return;
    }
    for(var i=0;i<99;i++){
      if(typeof(value['dev_code['+i+']']) != "undefined"){
        for(var j in dev_list){
          if(dev_list[j].dev_no == value['dev_code['+i+']']){
            dev_list[j].repair_content.reason = value['reason['+i+']'];
            break;
          }
        }
      }else{
        break;
      }
    }
    for(var i in dev_list){
      if(dev_list[i].repair_content.reason == ""){
        wx.showToast({
          title: '未输入设备故障信息',
          icon:"none"
        })
        return;
      }
    }
    if(Number(repair_delivery_type) == 2){
      var str = "";
      console.log(repair_delivery_content);
      if(repair_delivery_content.delivery_company == ""){
        str = "未输入快递公司名称";
      }else if(repair_delivery_content.delivery_number == ""){
        str = "未输入快递单号";
      }else if(repair_delivery_content.receive_back_address == ""){
        str = "未输入寄回地址";
      }
      if(str != ""){
        wx.showToast({
          title: str,
          icon:"none"
        })
        return;
      }
    }
    var send = {
      api_name: "apply_device_repair",
      repair_delivery_type:repair_delivery_type,
      dev_list:dev_list,
      repair_delivery_content:repair_delivery_content,
      login_manager_id: PageThis.data.userInfo.manager_id
    }
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: send,
      success:function(res){
        var ret = res.data;
        if(Number(ret.state) === 1){
          wx.showToast({
            title: '保存成功',
            success(res){
              wx.redirectTo({
                url: '../afterSaleList/index',
              })
            }
          })
        }else{
          wx.showToast({
            title: ret.msg,
            icon:"none"
          })
          return;
        }
      }
    })
  },
  scanDelivery(){
    var PageThis = this;
    var deliveryInfo = PageThis.data.deliveryInfo;
    wx.scanCode({
      scanType:"barCode",
      success (res) {
        deliveryInfo['delivery_number'] = res.result;
        console.log(deliveryInfo);
        PageThis.setData({
          deliveryInfo:deliveryInfo
        })
      }
    })
  }
})