// pages/managerUser/index.js
const app = getApp();
Page({

  /**
   * 页面的初始数据
   */
  data: {
    userInfo:[],
    manager_type:[],
    type_index:0,
    type_id:0,
    p_index:0,
    p_id:0,
    showPartner:0,
    showProportion:0,
    manager_username:0,
    manager_password:0,
    manager_nickname:0,
    manager_percent:0,
    manager_fee:0,
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    var PageThis = this;
    var userInfo = wx.getStorageSync('userInfo');
    var manager_type = [];
    if(userInfo['manager_type'] == 1){
      manager_type = [
        {
          type_title:"管理员",
          type_id:1
        },
        {
          type_title:"生产厂商",
          type_id:2
        },
        {
          type_title:"合伙人",
          type_id:3
        },
        {
          type_title:"运维人员",
          type_id:4
        },
        {
          type_title:"介绍人",
          type_id:5
        },
        {
          type_title:"酒店管理员",
          type_id:6
        },
        {
          type_title:"补货员",
          type_id:7
        },
      ]
    }else if(userInfo['manager_type'] == 2){
      wx.showToast({
        title: '您没权限',
        icon:'none'
      });
      return false;
    }else if(userInfo['manager_type'] == 3 || userInfo['manager_type'] == 4){
      manager_type = [
        {
          type_title:"合伙人",
          type_id:3
        },
        {
          type_title:"运维人员",
          type_id:4
        },
        {
          type_title:"介绍人",
          type_id:5
        },
        {
          type_title:"酒店管理员",
          type_id:6
        },
        {
          type_title:"补货员",
          type_id:7
        },
      ];
    }else if(userInfo['manager_type'] == 5){
      wx.showToast({
        title: '您没权限',
        icon:'none'
      });
      return false;
    }else if(userInfo['manager_type'] == 6){
      manager_type = [
        {
          type_title:"补货员",
          type_id:7
        },
      ]
    }else if(userInfo['manager_type'] == 7){
      wx.showToast({
        title: '您没权限',
        icon:'none'
      });
      return false;
    }
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo'),
      manager_type:manager_type
    })
    PageThis.getPartnerList();
  },
  changeInput:function(e){
    var PageThis = this;
    var name = e.currentTarget.dataset.name;
    PageThis.setData({
      [name]: e.detail.value
    })
  },
  changePicker:function(e){
    var PageThis = this;
    var value = e.detail.value;
    var type_id = PageThis.data.manager_type[value].type_id;
    var userInfo = wx.getStorageSync('userInfo');
    var pid = 0;
    var showPartner = 0;
    var showProportion = 0;
    var need_arr = [3,4,5,6,7];
    if((type_id == 3 || type_id == 4 || type_id == 5 || type_id == 6 || type_id == 7) && (userInfo['manager_type'] == 1 || userInfo['manager_type'] == 3)){
       //需要展示合伙人
       showPartner = 1;
    }else if(userInfo['manager_type'] == 4 || userInfo['manager_type'] == 6){
      pid = userInfo['manager_pid'];
      //不展示合伙人选项
      showPartner = 0;
    }
    if((type_id == 3|| type_id == 5 || type_id == 6 )){
       //展示分账比例和提现手续费输入
       showProportion = 1;
    }else{
      //不展示分账比例和提现手续费输入
      showProportion = 0;
    }
    PageThis.setData({
      "type_index": value,
      "type_id":type_id,
      "p_id":pid,
      "showPartner":showPartner,
      "showProportion":showProportion,
    });
  },
  changePartnerPicker:function(e){
    var PageThis = this;
    var value = e.detail.value;
    var p_id = PageThis.data.partner_list[value].manager_id;
    PageThis.setData({
      "p_index": value,
      "p_id":p_id
    })
  },
  getPartnerList:function(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data:{
        api_name: "get_partner_list",
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(res){
        var data = res.data.data;
        var unshiftData ={};
        unshiftData={
          'manager_id':0,
          'manager_nickname':'顶级合伙人'
        }
        data.unshift(unshiftData);
        PageThis.setData({
          "partner_list": data
        })
        console.log(data);
      }
    })
  },
  createManager:function(){
    var PageThis = this;
    var manager_username = PageThis.data.manager_username;
    var manager_password = PageThis.data.manager_password;
    var manager_nickname = PageThis.data.manager_nickname;
    if(manager_nickname =="" || manager_nickname.length<2){
      wx.showToast({
        title: '请输入正确的用户名',
        icon: 'none',
        duration: 2000
      })
      return false;
    }
    if(manager_username=="" || manager_username.length < 5){
      wx.showToast({
        title: '请输入大于5位的登录账号',
        icon: 'none',
        duration: 2000
      })
      return false;
    }
    if(manager_password=="" || manager_password.length<6){
      wx.showToast({
        title: '请输入大于6位的登录密码',
        icon: 'none',
        duration: 2000
      })
      return false;
    }
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "create_manager",
        manager_pid: PageThis.data.p_id,
        manager_type: PageThis.data.type_id,
        manager_username: PageThis.data.manager_username,
        manager_password: PageThis.data.manager_password,
        manager_nickname: PageThis.data.manager_nickname,
        manager_percent: PageThis.data.manager_percent,
        manager_fee: PageThis.data.manager_fee,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(res){
        res = res.data;
        wx.showToast({
          title: res.msg,
          icon: 'none',
          duration: 2000
        })
        if(res.state==1){
          setTimeout(function () {
            wx.switchTab({
              url: '../index/index',
            })
          }, 2000);
        }
      }
    })
  }
})