const app = getApp();
Page({
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    deviceList: [],
    search_type: 0,
    search_value: "",
    bind_value: -1,
    state_value: -1,
    searchArray: ['酒店','合伙人','设备号'],
    apiName:"device_list",
    select_arr:[],
    selectValue:0,
    showSelect:false,
    searchBoxHeight:14,
  },
  onLoad: function (options) {
    var type = options.type;
    console.log(type);
    this.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
    if (type == "undefined" || typeof(type) == "undefined"){
      this.setData({
        showSelect: false,
        searchBoxHeight:14
      })
      type = "device_list";
    }else if(type != "lower_electric_device"){
      var select_arr = [];
      switch(type){
        case "one_month_no_orders_device":
          select_arr = ['七天未成交','一月未成交','两月未成交'];
          break;
        case "three_day_no_rep_device":
          select_arr = ['三天未补货','四天未补货','五天未补货','六天未补货','七天未补货'];
          break;
        case "one_week_no_scan_device":
          select_arr = ['一周未扫码','两周未扫码','三周未扫码','一月未扫码','两月未扫码'];
          break;
      }
      this.setData({
        select_arr: select_arr,
        showSelect: true,
        searchBoxHeight:24,
      })
    }
    this.setData({
      apiName:type
    })
    this.getDeviceList();
  },
  /**页面跳转 */
  navigateTo: function (e) {
    var _url = e.currentTarget.dataset.url;
    var _id = e.currentTarget.dataset.id;
    wx.navigateTo({
      url: _url + "?id=" + _id,
    })
  },
  /**获取设备列表 */
  getDeviceList:function(){
    var PageThis = this;
    wx.showLoading({
      title: '数据加载中',
    })
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: PageThis.data.apiName,
        search_type: Number(PageThis.data.search_type)+1,
        search_value: PageThis.data.search_value,
        time_type:Number(PageThis.data.selectValue)+1,
        bind_value: PageThis.data.bind_value,
        state_value: PageThis.data.state_value,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success: function (res) {
        var data = res.data.data;
        for(var i in data){
          data[i]['show_list'] = "false";
          data[i]['hotel_img'] = "../../images/icons/arrow_down.png";
          for(var k in data[i].dev_list){
            var device_title = "未分配酒店设备";
            var rep_nickname = "未分配补货员";
            var lattice_arr = [];
            for(var x in data[i].dev_list[k].dev_no_stock_lattice){
              lattice_arr.push(Number(data[i].dev_list[k].dev_no_stock_lattice[x].lat_title))
            }
            if (Number(data[i].dev_list[k].dev_hotel_id) > 0 && data[i].dev_list[k].dev_hotel_room != "") {
              device_title = data[i].dev_list[k].hotel_title + data[i].dev_list[k].dev_hotel_room;
            } else if (data[i].dev_list[k].dev_room_address != "") {
              device_title = data[i].dev_list[k].dev_room_address;
            }else if(Number(data[i].dev_list[k].dev_hotel_id) > 0){
              device_title = "未分配房间设备";
            }
            if (data[i].rep_nickname != "" && data[i].rep_nickname != null){
              rep_nickname = data[i].rep_nickname;
            }
            var obj = {
              "dev_id": data[i].dev_list[k].dev_id,
              "dev_no": data[i].dev_list[k].dev_no,
              "dev_no_stock_lattice": lattice_arr,
              "dev_state": data[i].dev_list[k].dev_state,
              "device_title": device_title,
              "rep_nickname": rep_nickname
            }
            data[i].dev_list[k] = obj;
          }
        }
        PageThis.setData({
          "deviceList": data
        })
        wx.hideLoading({
          success: (res) => {},
        })
      }
    })
  },
  changeSearchType:function(e){
    var PageThis = this;
    var id = e.detail.value;
    PageThis.setData({
      "search_type": id
    })
  },
  searchValueChange:function(e){
    var PageThis = this;
    PageThis.setData({
      "search_value": e.detail.value
    })
  },
  //扫描二维码
  scanCode(){
    var PageThis = this;
    wx.scanCode({
      scanType:"qrCode",
      success (res) {
        var scan_url = res.result;
        var thisDevNo = scan_url.replace(app.globalData.serverInfo.qrReplaceUrl, '');
        if(thisDevNo != "" ){
          PageThis.setData({
            "search_value":thisDevNo,
            "search_type":2
          })
          PageThis.getDeviceList();
        }else{
          wx.showToast({
            title: '无效二维码',
            icon:"none"
          })
        }
      }
    })
  },
  hotel_click(e){
    var PageThis = this;
    var deviceList = PageThis.data.deviceList
    var id = e.currentTarget.dataset.id;
    var type = e.currentTarget.dataset.type;
    for(var i in deviceList){
      if(Number(deviceList[i]['hotel_id']) == Number(id)){
        if(type == "true"){
          deviceList[i]['show_list'] = "false";
          deviceList[i]['hotel_img'] = "../../images/icons/arrow_down.png";
        }else{
          deviceList[i]['show_list'] = "true";
          deviceList[i]['hotel_img'] = "../../images/icons/arrow_up.png";
        }
      }else{
        deviceList[i]['show_list'] = "false";
        deviceList[i]['hotel_img'] = "../../images/icons/arrow_down.png";
      }
    }
    PageThis.setData({
      deviceList:deviceList
    })
  },
  pickerChange:function(e){
    var PageThis = this;
    var val = e.detail.value;
    var name = e.currentTarget.dataset.name;
    switch(name){
      case "select":
        PageThis.setData({
          selectValue:val
        })
        break;
    }
  },
})