// pages/deviceOrdersCount/index.js
const app = getApp();
Page({
  /**
   * 页面的初始数据
   */
  data: {
    scanList:[],
    dev_no:"",
    hotel_name:"",
    start_time:"请选择开始时间",
    end_time: "请选择结束时间",
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    this.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
    this.getScanList();
  },
  pickerChange: function (e) {
    var PageThis = this;
    var val = e.detail.value;
    var name = e.target.dataset.name;
    switch (name) {
      case "start_time":
        PageThis.setData({
          start_time: val
        })
        break;
      case "end_time":
        PageThis.setData({
          end_time: val
        })
        break;
    }
  },
  getScanList(){
    var PageThis = this;
    wx.showLoading({
      title: '数据加载中',
    })
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_device_scan_list",
        dev_no: PageThis.data.dev_no,
        hotel_title: PageThis.data.hotel_name,
        start_time: PageThis.data.start_time == "请选择开始时间" ? "" : PageThis.data.start_time,
        end_time: PageThis.data.end_time == "请选择结束时间" ? "" : PageThis.data.end_time,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(res){
        wx.hideLoading();
        var data = res.data.data;
        PageThis.setData({
          "scanList": data
        })
        console.log(data);
      }
    })
  },
  reset:function(){
    var PageThis = this;
    PageThis.setData({
      dev_no: "",
      hotel_name: "",
      start_time: "请选择开始时间",
      end_time: "请选择结束时间",
    })
  }
})