// pages/getWechat/index.js
const app = getApp()
Page({
  /**
   * 页面的初始数据
   */
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    canIUse: wx.canIUse('button.open-type.getUserInfo')
  },
  setBindWechat:function(){
   var PageThis = this;
   PageThis.getWxSession();
  },
  getWechatInfo:function(){
    var PageThis = this;
    PageThis.getWxSession();
   },
   bindGetUserInfoGo(e) {
    var PageThis = this;
    console.log(e);
    console.log(PageThis.data.session);
    wx.setStorage({
      key: 'iv',
      data: e.detail.iv
    })
    wx.setStorage({
      key: 'encryptedData',
      data: e.detail.encryptedData
    })
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      data: {
        api_name: "sure_bind_wx",
        target: app.globalData.ThisWechatTarget,
        type: app.globalData.ThisWechatType,
        iv: e.detail.iv,
        encryptedData: e.detail.encryptedData,
        session_key: PageThis.data.session,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      method: 'POST',
      header: { 'content-type': 'application/json' },
      success: function (res) {
        wx.showToast({
          title: res.data.msg,
          icon:'none',
          duration: 2000
        })
      }
    })
  },
   getAuthSetting:function(){
    // 查看是否授权
    wx.getSetting({
      success(res) {
        if (res.authSetting['scope.userInfo']) {
          // 已经授权，可以直接调用 getUserInfo 获取头像昵称
          wx.getUserInfo({
            success: function (res) {
              console.log(res);
              wx.setStorage({
                key: 'VerificationData',
                data: res
              })
            }
          })
        }
      }
    })
   },
  getWxSession:function(){
    var PageThis = this;
    wx.login({
      success(res) {
        if (res.code) {
          // 发起网络请求
          wx.request({
            url: 'https://m.dalvv.com/managerApi',
            data: {
              code: res.code,
              api_name: "get_wx_session",
              target: app.globalData.ThisWechatTarget,
              type: app.globalData.ThisWechatType,
              login_manager_id: PageThis.data.userInfo.manager_id
            },
            method: 'POST',
            header: { 'content-type': 'application/json' },
            success: function (res) {
              PageThis.setData({
                session:res.data.data.session_key
              })
            }
          })
        } else {
          console.log('登录失败！' + res.errMsg)
        }
      }
    })
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    this.getAuthSetting();
    this.setBindWechat();
    this.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})