// pages/goodsDetail/index.js
const app = getApp();
Page({
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    goodsDetail:{},
    goodsId:0
  },
  onLoad: function (options) {
    var id = options.id;
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
    this.setData({
      "goodsId":id
    })
  },
  onShow:function(){
    this.getGoodsDetail();
  },
  //**页面跳转 */
  goodsCopy: function (e) {
    var PageThis = this;
    var _url = "../updateGoodsDetail/index";
    var _id = e.currentTarget.dataset.id;
    wx.showModal({
      title: '温馨提示',
      content: '是否复制该商品',
      success (res) {
        if (res.confirm) {
          wx.request({
            url: app.globalData.serverInfo.gateWayUrl,
            header: {
              'content-type': 'application/json'
            },
            method: 'POST',
            data:{
              api_name: "goods_copy",
              goods_id: _id,
              login_manager_id: PageThis.data.userInfo.manager_id
            },
            success:function(res){
              wx.showToast({
                title: res.data.msg,
                icon: 'success',
                duration: 1500,
              })
             setTimeout(function(){
              wx.navigateTo({
                url: _url + "?id=" + res.data.data,
                })
            },1500);
            }
          })
        } else if (res.cancel) {
          console.log('用户点击取消')
        }
      }
    })
    
    
  },
  //**页面跳转 */
  navigateTo: function (e) {
    var _url = e.currentTarget.dataset.url;
    var _id = e.currentTarget.dataset.id;
    wx.navigateTo({
      url: _url + "?id=" + _id,
    })
  },
  getGoodsDetail:function(){
    var PageThis = this;
    var id = PageThis.data.goodsId;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data:{
        api_name: "goods_detail",
        goods_id: id,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(res){
        var data = res.data.data;
        data['g_pic'] = JSON.parse(data['g_pic']);
        if(Number(data['g_money_type']) === 1){
          data['g_money_type'] = '营业额分成';
        }else{
          data['g_money_type'] = '利润分成';
        }
        PageThis.setData({
          "goodsDetail": data
        })
      }
    })
  }
})