// pages/goodsPlan/index.js
const app = getApp();
Page({
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    planList:[],
    search_value: "",
  },
  onLoad: function (options) {
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
    this.getPlanList();
  },
  //**页面跳转 */
  navigateTo: function (e) {
    var _url = e.currentTarget.dataset.url;
    var _id = e.currentTarget.dataset.id;
    wx.navigateTo({
      url: _url + "?id=" + _id,
    })
  },
  upDevPlay:function(e){
    var PageThis = this;
    var _id = e.currentTarget.dataset.id;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "docking_goods_plan",
        gp_id: _id,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(ret){
        wx.showToast({
          title: ret.data.msg,
          icon: 'none',
          duration: 2000
        })
      }
    })
  },
  getPlanList:function(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "goods_plan",
        search_value: PageThis.data.search_value,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(ret){
        var data = ret.data.data;
        PageThis.setData({
          "planList": data
        })
      }
    })
  },
  searchValueChange: function (e) {
    var PageThis = this;
    PageThis.setData({
      "search_value": e.detail.value
    })
  },
})