// pages/hotelDetail/index.js
const app = getApp();
Page({
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    hotelDetail:{},
    hotelId: 0
  },
  onLoad: function (options) {
    var id = options.id;
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
    this.setData({
      "hotelId": id
    })
  },
  onShow: function () {
    this.getHotelDetail();
  },
  //**页面跳转 */
  navigateTo: function (e) {
    var _url = e.currentTarget.dataset.url;
    var _id = e.currentTarget.dataset.id;
    wx.navigateTo({
      url: _url + "?id=" + _id,
    })
  },
  getHotelDetail:function(){
    var PageThis = this;
    var id = PageThis.data.hotelId;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "hotel_detail",
        hotel_id: id,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(res){
        console.log(res);
        var data = res.data.data;
        PageThis.setData({
          "hotelDetail": data
        })
      }
    })
  }
})