//index.js
//获取应用实例
const app = getApp()

Page({
    data: {
        userInfo: wx.getStorageSync('userInfo'),
        bottomNavList: app.globalData.bottomNavList,
        indexIcon: app.globalData.indexIcon,
        dateIndex:2,
        bootomNavIndex:1,
        dateActive1: '',
        dateActive2: 'date_active',
        dateActive3: '',
        handleNum:0,
        topData:{
            topData1:0,
            topData2: 0,
            topData3: 0,
        },
        dataBox:{
            no_stock_device:0,
            total_device:0,
            no_stock_p:0
        },
        ordersDataCount:{},
        notice:"您好！欢迎使用",
        time:0,
        px:0
    },
    onLoad: function () {
        var PageThis = this;
        PageThis.setData({
            userInfo:wx.getStorageSync('userInfo')
        });
        PageThis.getNotice();
        PageThis.getToDoList();
        PageThis.getPageInfo();
    },
    onShow: function () {
        this.setData({
            "handleNum":app.globalData.handleNum
        })
    },
    //**页面跳转 */
    navigateTo: function (e) {
        var _url = e.currentTarget.dataset.url;
        wx.navigateTo({
            url: _url,
        })
    },
    /**tap切换 */
    switchNav:function(e){
        var PageThis = this;
        var id = e.target.dataset.id;
        PageThis.setOrderData(id);
    },
    setOrderData:function(id){
        var PageThis = this;
        PageThis.setData({
            dateActive1: '',
            dateActive2: '',
            dateActive3: ''
        })
        switch(id){
            case "1":
                var data = {
                    topData1: PageThis.data.ordersDataCount.separate_yesterday_money,
                    topData2: PageThis.data.ordersDataCount.orders_yesterday_num,
                    topData3: PageThis.data.ordersDataCount.sales_yesterday_money,
                }
                PageThis.setData({
                    dateActive1: 'date_active',
                    topData: data
                })
                break;
            case "2":
                var data = {
                    topData1: PageThis.data.ordersDataCount.separate_today_money,
                    topData2: PageThis.data.ordersDataCount.orders_today_num,
                    topData3: PageThis.data.ordersDataCount.sales_today_money,
                }
                PageThis.setData({
                    dateActive2: 'date_active',
                    topData: data
                })
                break;
            case "3":
                var data = {
                    topData1: PageThis.data.ordersDataCount.separate_month_money,
                    topData2: PageThis.data.ordersDataCount.orders_month_num,
                    topData3: PageThis.data.ordersDataCount.sales_month_money,
                }
                PageThis.setData({
                    dateActive3: 'date_active',
                    topData: data
                })
                break;
        }
    },
    /**获取页面数据信息 */
    getPageInfo:function(){
        var PageThis = this;
        wx.request({
            url: app.globalData.serverInfo.gateWayUrl,
            header: {
                'content-type': 'application/json'
            },
            method: 'POST',
            data:{
                api_name: "device_count",
                login_manager_id: PageThis.data.userInfo.manager_id
            },
            success:function(res){
                var data = res.data.data;
                if (Number(data['total_device']) > 0){
                    data['no_stock_p'] = (data['no_stock_device'] / data['total_device'] * 100).toFixed(2);
                }else{
                    data['no_stock_p'] = 0;
                }
                PageThis.setData({
                    dataBox: data
                })
            }
        })
        wx.request({
            url: app.globalData.serverInfo.gateWayUrl,
            header: {
                'content-type': 'application/json'
            },
            method: 'POST',
            data: {
                api_name: "orders_count",
                login_manager_id: PageThis.data.userInfo.manager_id
            },
            success:function(res){
                var data = res.data.data;
                PageThis.setData ({
                    ordersDataCount: data
                },() => {
                    PageThis.setOrderData('2');
            });
            }
        })
    },
    getNotice(){
        var PageThis = this;
        wx.request({
            url: app.globalData.serverInfo.gateWayUrl,
            header: {
                'content-type': 'application/json'
            },
            method: 'POST',
            data: {
                api_name: "",
                login_manager_id: PageThis.data.userInfo.manager_id
            },
            success:function(res){
                PageThis.setData({
                    notice:res.data.data.mini_index_notice
                })
                var box_width = 0;
                var content_width = 0;
                var query = wx.createSelectorQuery();
                query.select('.sound_bar_box').boundingClientRect(function(rect){
                    box_width = rect.width;
                });
                query.select('.sound_bar_content').boundingClientRect(function(rect){
                    content_width = rect.width;
                }).exec();
                setTimeout(function(){
                    if(Number(content_width) > Number(box_width)){
                        var time = Math.ceil(content_width/30);
                        PageThis.setData({
                            time:Math.floor(content_width/30),
                            px:content_width*(-1)
                        })
                        setInterval(function(){
                            PageThis.setData({
                                time:0,
                                px:box_width
                            },Math.floor(content_width/30) * 1000)
                            setTimeout(function(){
                                PageThis.setData({
                                    time:Math.floor(content_width/30),
                                    px:content_width*(-1)
                                })
                            })
                        },time * 1000)
                    }
                },1000)
            }
        })
    },
    getToDoList(){
        var PageThis = this;
        wx.request({
            url: app.globalData.serverInfo.gateWayUrl,
            header: {
                'content-type': 'application/json'
            },
            method: 'POST',
            data: {
                api_name: "get_to_do_list",
                login_manager_id: PageThis.data.userInfo.manager_id
            },
            success:function(res){
                var data = res.data.data;
                app.globalData.handleNum = data.total_number;
                PageThis.setData({
                    "handleNum":data.total_number
                })
            }
        })
    },
})
