const app = getApp();
Page({
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    deviceList: [],
    search_type: 0,
    search_value: "",
    bind_value: -1,
    state_value: -1,
    searchArray: ['酒店', '合伙人', '设备号']
  },
  onShow: function (options) {
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
    this.getDeviceList();
  },
  //**页面跳转 */
  navigateTo: function (e) {
    var _url = e.currentTarget.dataset.url;
    var _id = e.currentTarget.dataset.id;
    wx.navigateTo({
      url: _url + "?id=" + _id,
    })
  },
  /**获取设备列表 */
  getDeviceList: function () {
    var PageThis = this;
    wx.showLoading({
      title: '信息加载中',
    })
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "no_stock_device",
        search_type: Number(PageThis.data.search_type) + 1,
        search_value: PageThis.data.search_value,
        bind_value: PageThis.data.bind_value,
        state_value: PageThis.data.state_value,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success: function (res) {
        var data = res.data.data;
        for (var i in data) {
          data[i]['show_list'] = "false";
          data[i]['hotel_img'] = "../../images/icons/arrow_down.png";
          for(var k in data[i].dev_list){
            var device_title = "未分配酒店设备";
            var rep_nickname = "未分配补货员";
            var lattice_arr = [];
            for(var x in data[i].dev_list[k].dev_no_stock_lattice){
              lattice_arr.push(Number(data[i].dev_list[k].dev_no_stock_lattice[x].lat_title))
            }
            if (Number(data[i].dev_list[k].dev_hotel_id) > 0 && data[i].dev_list[k].dev_hotel_room != "") {
              device_title = data[i].dev_list[k].hotel_title + data[i].dev_list[k].dev_hotel_room;
            } else if (data[i].dev_list[k].dev_room_address != "") {
              device_title = data[i].dev_list[k].dev_room_address;
            }else if(Number(data[i].dev_list[k].dev_hotel_id) > 0){
              device_title = "未分配房间设备";
            }
            if (data[i].dev_list[k].rep_nickname != "" && data[i].dev_list[k].rep_nickname != null) {
              rep_nickname = data[i].dev_list[k].rep_nickname;
            }
            var obj = {
              "dev_id": data[i].dev_list[k].dev_id,
              "dev_no": data[i].dev_list[k].dev_no,
              "dev_no_stock_lattice": lattice_arr,
              "dev_state": data[i].dev_list[k].dev_state,
              "device_title": device_title,
              "rep_nickname": rep_nickname
            }
            data[i].dev_list[k] = obj;
          }
        }
        PageThis.setData({
          "deviceList": data
        })
        wx.hideLoading({
          success: (res) => {},
        })
      }
    })
  },
  changeSearchType: function (e) {
    var PageThis = this;
    var id = e.detail.value;
    PageThis.setData({
      "search_type": id
    })
  },
  searchValueChange: function (e) {
    var PageThis = this;
    PageThis.setData({
      "search_value": e.detail.value
    })
  },
  hotel_click(e){
    var PageThis = this;
    var deviceList = PageThis.data.deviceList
    var id = e.currentTarget.dataset.id;
    var type = e.currentTarget.dataset.type;
    for(var i in deviceList){
      if(Number(deviceList[i]['hotel_id']) == Number(id)){
        if(type == "true"){
          deviceList[i]['show_list'] = "false";
          deviceList[i]['hotel_img'] = "../../images/icons/arrow_down.png";
        }else{
          deviceList[i]['show_list'] = "true";
          deviceList[i]['hotel_img'] = "../../images/icons/arrow_up.png";
        }
      }else{
        deviceList[i]['show_list'] = "false";
        deviceList[i]['hotel_img'] = "../../images/icons/arrow_down.png";
      }
    }
    PageThis.setData({
      deviceList:deviceList
    })
  },
  quickScan(){
    var PageThis = this;
    wx.scanCode({
      scanType:"qrCode",
      success (res) {
        var scan_url = res.result;
        var thisDevNo = scan_url.replace(app.globalData.serverInfo.qrReplaceUrl, '');
        if(thisDevNo != "" ){
          wx.request({
            url: app.globalData.serverInfo.gateWayUrl,
            header: {
              'content-type': 'application/json'
            },
            method: 'POST',
            data: {
              api_name: "find_device",
              dev_no: thisDevNo
            },
            success:function(ret){
              var data = ret.data;
              if(Number(data.state) === 1){
                var _url = "../replenishmentDetail/index";
                var _id = data.data.dev_id;
                wx.navigateTo({
                  url: _url + "?id=" + _id,
                })
              }else{
                wx.showToast({
                  title: data.msg,
                })
              }
            }
          })
        }else{
          wx.showToast({
            title: '无效二维码',
            icon:"none"
          })
        }
      }
    })
  }
})