// pages/ordersList/index.js
const app = getApp();
Page({
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    pay_no:"",
    hotelValue: [], //酒店列表数组
    hotelIndex:0, //酒店列表数组picker选中【键值】
    hotelId: 0,//存储的酒店ID
    managerValue: [], //合伙人列表数组
    managerIndex:0, //合伙人列表数组picker选中【键值】
    managerId: 0,//存储的合伙人ID
    partnerList: [],
    partnerValue: [],
    partnerName: "请选择合伙人",
    partner_id:"",
    start_time:"请选择开始时间",
    end_time:"请选择结束时间",
    ordersList:[]
  },
  //**页面跳转 */
  navigateTo: function (e) {
    var _url = e.currentTarget.dataset.url;
    var _id = e.currentTarget.dataset.id;
    wx.navigateTo({
      url: _url + "?id=" + _id,
    })
  },
  onLoad(){
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
  },
  onShow: function () {
    this.getOrdersList();
    this.getHotelList();
    this.getPartnerList();
  },
  getOrdersList: function () {
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_orders_list",
        pay_no: PageThis.data.pay_no,
        hotel_id: PageThis.data.hotelId,
        partner_id: PageThis.data.managerId,
        start_time: PageThis.data.start_time == "请选择开始时间" ? "" : PageThis.data.start_time,
        end_time: PageThis.data.end_time == "请选择结束时间" ? "" : PageThis.data.end_time,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(res){
        var data = res.data.data;
        PageThis.setData({
          "ordersList": data
        })
      }
    })
  },
  getHotelList: function () {
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "hotel_list_value",
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success: function (res) {
        var data = res.data.data;
        PageThis.setData({
          "hotelValue": data
        })
      }
    })
  },
  getPartnerList:function(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "manager_list_value",
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success: function (res) {
        var data = res.data.data;
        PageThis.setData({
          "managerValue": data,
        })
      }
    })
  },
  pickerChange:function(e){
    var PageThis = this;
    var name = e.currentTarget.dataset.name;
    var val = e.detail.value;
    switch(name){
      case "hotel":
        //hotelIndex存储picker选中【键值】
        //hotelId存储picker选中【h_id】
        PageThis.setData({
          hotelIndex: e.detail.value,
          hotelId: this.data.hotelValue[e.detail.value].h_id
        })
        break;
      case "partner":
        PageThis.setData({
          managerIndex: e.detail.value,
          managerId: this.data.managerValue[e.detail.value].manager_id
        })
        break;
      case "start_time":
        PageThis.setData({
          start_time: val
        })
        break;
      case "end_time":
        PageThis.setData({
          end_time: val
        })
        break;
    }
  },
  inputChange:function(e){
    var PageThis = this;
    PageThis.setData({
      "pay_no": e.detail.value
    })
  },
  reset:function(){
    var PageThis = this;
    PageThis.setData({
      pay_no: "",
      hotelName: "请选择酒店",
      hotel_id: 0,
      partnerName: "请选择合伙人",
      partner_id: 0,
      start_time: "请选择开始时间",
      end_time: "请选择结束时间",
    })
  }
})