// pages/resetDevice/index.js
const app = getApp();
Page({
  data: {
    userInfo: wx.getStorageSync('userInfo'),
  },
  onLoad: function (options) {
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
  },
  scanQrCode:function(){
    wx.scanCode({
      success: (res) => {
        var url = res.result;
        var devCode = url.replace(app.globalData.serverInfo.qrReplaceUrl,"");
        wx.request({
          url: app.globalData.serverInfo.gateWayUrl,
          header: {
            'content-type': 'application/json'
          },
          method: 'POST',
          data: {
            api_name: "reset_device_info",
            dev_no: devCode,
            login_manager_id: PageThis.data.userInfo.manager_id
          },
          success:function(res){
            var res = res.data;
            if(res.state == 1){
              wx.showToast({
                title: '重置成功',
                icon: "success",
                duration: 2000
              })
            }else{
              wx.showToast({
                title: res.msg,
                icon: "none",
                duration: 2000
              })
            }
          }
        })
      },
      fail: (res) => {
        console.log(res);
      }
    })
  }
})