// pages/roomHelper/index.js
const app = getApp();
Page({

  /**
   * 页面的初始数据
   */
  data: {
    new_room:"",
  },
  getInputValueRoom(e){
    this.setData({
      new_room: e.detail.value,
    })
  },
  snoScan:function(){
    var PageThis = this;
    wx.scanCode({
      success (res) {
        var scan_url = res.result;
        var thisDevNo = scan_url.replace(app.globalData.serverInfo.qrReplaceUrl, '');
        if(thisDevNo.length!=10){
          wx.showToast({
            title: '无效二维码:'+thisDevNo,
            icon: 'none',
            duration:3000
          })
          return false;
        }
        PageThis.getDeviceData(thisDevNo);
      }
    })
  },
  getDeviceData:function(self){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "post_no_device_detail",
        login_manager_id: PageThis.data.userInfo.manager_id,
        device_no: self
      },
      success:function(ret){
        var thisData = ret.data.data;
        PageThis.setData({
          "deviceData": thisData
        })
        wx.showToast({
          title: ret.data.msg,
          icon: 'none',
          duration:3000
        })
      }
    })
  },
  updateDeviceRoom:function(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "update_device_room",
        login_manager_id: PageThis.data.userInfo.manager_id,
        device_id: PageThis.data.deviceData.dev_id,
        device_room: PageThis.data.new_room,
      },
      success:function(ret){
        wx.showToast({
          title: ret.data.msg,
          icon: 'none',
          duration:3000
        })
      }
    })
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})