const app = getApp()

Page({
  data: {
    userInfo:[],
    bottomNavList: app.globalData.bottomNavList,
    bootomNavIndex: 3,
    listData : [
      {
        icon : '../../images/icons/icon(11).png',
        title : 'D600专用',
        url : '../deployToolSec/index'
      },
      {
        icon : '../../images/icons/icon(11).png',
        title : '扫码绑定',
        url : '../warehouse/index'
      },
      {
        icon : '../../images/icons/icon(11).png',
        title : '设置方案',
        url : '../tool/plan'
      },
      {
        icon : '../../images/icons/icon(11).png',
        title : '房间助手',
        url : '../roomHelper/index'
      },
    ]
  },
  onLoad(options){
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
  },
  //**页面跳转 */
  navigateTo: function (e) {
    var PageThis = this;
    var _url = e.currentTarget.dataset.url;
    if (_url == "../warehouse/index"){
      wx.scanCode({
        scanType:['qrCode'],
        success (res) {
          console.log(res)
          var scan_url = res.result;
          var code = scan_url.replace(app.globalData.serverInfo.qrReplaceUrl,'');
          if(code != ""){
            wx.showModal({
              title: '绑定设备',
              content: '确定绑定设备编号为：'+code+"的设备？",
              success (res) {
                if (res.confirm) {
                  wx.request({
                    url: app.globalData.serverInfo.gateWayUrl,
                    header: {
                      'content-type': 'application/json'
                    },
                    method: 'POST',
                    data: {
                      api_name: "scan_qr_bind_device",
                      device_no: code,
                      login_manager_id: PageThis.data.userInfo.manager_id
                    },
                    success:function(res){
                      var data = res.data;
                      if(Number(data.state) === 1){
                        wx.showToast({
                          title: '绑定成功',
                        })
                      }else{
                        wx.showToast({
                          title: data.msg,
                          icon:"none"
                        })
                      }
                    }
                  })
                } else if (res.cancel) {
                  console.log('用户点击取消')
                }
              }
            })
          }
        }
      })
    }else{
      wx.navigateTo({
        url: _url,
      })
    }
  },
})