// pages/tool/plan.js
const app = getApp();
Page({

  /**
   * 页面的初始数据
   */
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    replenishment: ['否', '是'],
    replenishmentIndex: 0,
    planIndex: 0,
    s_no: "",
    e_no: "",
    gp_id:0,
  },
  bindPickerChange: function(e) {
    this.setData({
      planIndex: e.detail.value,
      gp_id: this.data.planList[e.detail.value].gp_id
    })
    console.log(this.data.gp_id)
  },
  replenishmentChange: function(e) {
    this.setData({
      replenishmentIndex: e.detail.value
    })
  },
  getInputValueSno(e){
    this.setData({
      s_no: e.detail.value,
    })
  },
  getInputValueEno(e){
    this.setData({
      e_no: e.detail.value,
    })
  },
  snoScan:function(){
    var PageThis = this;
    wx.scanCode({
      success (res) {
        var scan_url = res.result;
        var thisDevNo = scan_url.replace(app.globalData.serverInfo.qrReplaceUrl, '');
        if(thisDevNo.length!=10){
          wx.showToast({
            title: '无效二维码:'+thisDevNo,
            icon: 'none',
            duration:3000
          })
          return false;
        }
        if(PageThis.data.e_no==0){
          PageThis.setData({
            "s_no": thisDevNo,
            "e_no": thisDevNo
          })
        }else{
          PageThis.setData({
            "s_no": thisDevNo
          })
        }
      }
    })
  },
  enoScan:function(){
    var PageThis = this;
    wx.scanCode({
      success (res) {
        var scan_url = res.result;
        var thisDevNo = scan_url.replace(app.globalData.serverInfo.qrReplaceUrl, '');
        if(thisDevNo.length!=10){
          wx.showToast({
            title: '无效二维码:'+thisDevNo,
            icon: 'none',
            duration:3000
          })
          return false;
        }
        PageThis.setData({
          "e_no": thisDevNo
        })
      }
    })
  },
  getPlanList:function(){
    var PageThis = this;
    var thisPlan = [{ gp_id: 0, gp_title: "请选择" }]
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "goods_plan",
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(ret){
        var thisData = ret.data.data;
        for (var i = 0; i < thisData.length; i++) {
          var thisFor = { gp_id: thisData[i]['gp_id'],gp_title: thisData[i]['gp_title'] }
          thisPlan.push(thisFor);
        }
        PageThis.setData({
          "planList": thisPlan
        })
      }
    })
  },
  devicePlan:function(){
    var PageThis = this;
    if(PageThis.data.gp_id<=0){
      wx.showToast({
        title: '请选择商品方案',
        icon: 'none',
      })
      return false;
    }
    if(PageThis.data.s_no<=0 ||PageThis.data.s_no.length!=10){
      wx.showToast({
        title: '请填写正确开始设备编号',
        icon: 'none',
      })
      return false;
    }
    if(PageThis.data.e_no<=0 ||PageThis.data.e_no.length!=10){
      wx.showToast({
        title: '请填写正确结束设备编号',
        icon: 'none',
      })
      return false;
    }
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "bind_device_goods_plan",
        gp_id: PageThis.data.gp_id,
        fill_stock: PageThis.data.replenishmentIndex,
        dev_id: 0,
        dev_start: PageThis.data.s_no,
        dev_end: PageThis.data.e_no,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(ret){
        console.log(ret);
        wx.showToast({
          title: ret.data.msg,
          icon: 'none',
          duration: 2000
        });
      }
    })
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
    this.getPlanList();
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})