// pages/trainInfo/index.js
const app = getApp();
Page({
  data: {
    userInfo:{},
    tabList:[],
    list:[],
    tab_index:1
  },
  onLoad: function (options) {
    var item = ["培训资料","培训视频"];
    var list = [];
    for(var i in item){
      var obj = {
        "tabName":item[i],
        "tabClass":"",
        "tabIndex":i,
        "tabContent":[]
      }
      list.push(obj);
    }
    list[0]['tabClass'] = "tab_item_active";
    this.setData({
      userInfo:wx.getStorageSync('userInfo'),
      tabList:list
    });
  },
  onShow: function () {
    this.getList();
  },
  onTabItem(e){
    var PageThis = this;
    var index = e.currentTarget.dataset.page;
    var tabList = PageThis.data.tabList;
    for(var i in tabList){
      if(Number(tabList[i].tabIndex) === Number(index)){
        tabList[i].tabClass = "tab_item_active";
      }else{
        tabList[i].tabClass = "";
      }
    }
    PageThis.setData({
      tab_index:Number(index)+1,
      tabList:tabList
    })
  },
  getList(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_train_info",
        login_manager_id: PageThis.data.userInfo.manager_id,
      },
      success:function(res){
        var data = res.data.data;
        PageThis.setData({
          list:data
        })
      }
    })
  },
  //**页面跳转 */
  navigateTo: function (e) {
    var _url = e.currentTarget.dataset.url;
    var _id = e.currentTarget.dataset.id;
    wx.navigateTo({
      url: _url + "?id=" + _id,
    })
  }
})