// pages/updateCard/index.js
const app = getApp();
Page({
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    cardId: 0,
    cardInfo: {}
  },
  onLoad:function(options){
    var id = options.id;
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
    this.setData({
      cardId: id
    })
    this.getCardDetail();
  },
  getCardDetail: function () {
    var PageThis = this;
    var id = PageThis.data.cardId;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_bank_card_detail",
        card_id: id,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success: function (res) {
        var data = res.data.data;
        PageThis.setData({
          "cardInfo": data
        })
      }
    })
  },
  createCard: function () {
    var PageThis = this;
    var cardInfo = PageThis.data.cardInfo;
    cardInfo['api_name'] = "update_bank_card";
    cardInfo['login_manager_id'] = PageThis.data.userInfo.manager_id
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: cardInfo,
      success: function (res) {
        res = res.data;
        if (res.state == 1) {
          wx.showToast({
            title: '保存成功',
            icon: 'success',
            duration: 1500,
          })
          setTimeout(function () {
            wx.navigateBack()
          }, 1500);
        } else {
          wx.showToast({
            title: res.msg,
            icon: 'none',
            duration: 2000,
          })
        }
      }
    })
  },
  inputChange: function (e) {
    var PageThis = this;
    var name = e.currentTarget.dataset.name;
    var data = PageThis.data.cardInfo;
    data[name] = e.detail.value;
    PageThis.setData({
      "cardInfo": data
    })
  },
})