// pages/createGoodsPlan/index.js
const app = getApp();
Page({
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    lat_type: [],
    lat_type_value: [],
    lat_type_name: "请选择格子机型",
    goods_list: [],
    goods_list_value: [],
    planInfo: {
      "gp_title": "",
      "gp_lat_type_id": 0,
      "gp_content": {}
    }
  },
  onLoad: function (options) {
    var id = options.id;
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
    this.getLatticeType();
    this.getGoodsList();
    this.getPlanDetail(id);
  },
  getPlanDetail:function(id){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "goods_plan_detail",
        gp_id: id,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success: function (res) {
        var data = res.data.data
        PageThis.setData({
          "planInfo": data,
          "lat_type_name":data['lt_title']
        })
      }
    })
  },
  getLatticeType: function () {
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "lattice_type",
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success: function (res) {
        var data = res.data.data;
        var lat_list = [];
        for (var i in data) {
          lat_list.push(data[i].lt_title);
        }
        PageThis.setData({
          "lat_type_value": data,
          "lat_type": lat_list
        })
      }
    })
  },
  getGoodsList: function () {
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "goods_list",
        search_title: PageThis.data.searchTitle,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success: function (res) {
        var data = res.data.data;
        var goods_list = [];
        for (var i in data) {
          goods_list.push(data[i].g_title);
        }
        PageThis.setData({
          "goods_list_value": data,
          "goods_list": goods_list
        })
      }
    })
  },
  changeName: function (e) {
    var PageThis = this;
    var planInfo = PageThis.data.planInfo;
    planInfo['gp_title'] = e.detail.value;
    PageThis.setData({
      "planInfo": planInfo
    })
  },
  latTypeChange: function (e) {
    var PageThis = this;
    var index = e.detail.value;
    var lat_type = PageThis.data.lat_type_value;
    var obj = lat_type[index];
    var planInfo = PageThis.data.planInfo;
    var new_content = [];
    for (var i = 0; i < obj.lt_num; i++) {
      var item = planInfo.gp_content[i] ? planInfo.gp_content[i] : { "plan_goods_id": 0, "plan_goods_title": "请选择商品" ,"plan_goods_price":0};
      new_content.push(item);
    }
    planInfo['gp_lat_type_id'] = obj['lt_id'];
    planInfo['gp_content'] = new_content;
    PageThis.setData({
      "lat_type_name": obj['lt_title'],
      "planInfo": planInfo
    })
  },
  goodsChange: function (e) {
    var PageThis = this;
    var index = e.target.dataset.index;
    var val = e.detail.value;
    var planInfo = PageThis.data.planInfo;
    var goodsInfo = PageThis.data.goods_list_value[val];
    planInfo['gp_content'][index]['plan_goods_title'] = goodsInfo['g_title'];
    planInfo['gp_content'][index]['plan_goods_id'] = goodsInfo['g_id'];
    planInfo['gp_content'][index]['plan_goods_price'] = goodsInfo['g_sale_price'];
    PageThis.setData({
      "planInfo": planInfo
    });
  },
  createPlan: function () {
    var PageThis = this;
    var planInfo = PageThis.data.planInfo;
    planInfo['api_name'] = "update_goods_plan";
    planInfo['login_manager_id'] = PageThis.data.userInfo.manager_id
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: planInfo,
      success: function (res) {
        res = res.data;
        if (res.state == 1) {
          wx.showToast({
            title: "保存成功",
            icon: 'success',
            duration: 2000,
            success: function () {
              setTimeout(function () {
                wx.navigateBack({})
              }, 1500);
            }
          })
        } else {
          wx.showToast({
            title: res.msg,
            icon: 'none',
            duration: 2000
          })
        }
      }
    })
  }
})