// pages/userDetail/index.js
const app = getApp();
Page({
  /**
   * 页面的初始数据
   */
  data: {
    userInfo:[],
    managerId:0,
    managerDetail:{},
    showPer:"none"
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    var id = options.id;
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
    this.setData({
      "managerId": id
    })
  },
  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    this.getManagerInfo();
  },
  //**页面跳转 */
  navigateTo: function (e) {
    var _url = e.currentTarget.dataset.url;
    var _id = e.currentTarget.dataset.id;
    wx.navigateTo({
      url: _url + "?id=" + _id,
    })
  },
  //获取用户信息
  getManagerInfo(){
    var PageThis = this;
    var id = PageThis.data.managerId;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_manager_info",
        manager_id: id,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(res){
        console.log(res);
        var data = res.data.data;
        switch(Number(data.manager_type)){
          case 1:
            data['manager_type_name'] = "平台";
            break;
          case 2:
            data['manager_type_name'] = "生产厂商";
            break;
          case 3:
            data['manager_type_name'] = "合伙人";
            break;
          case 4:
            data['manager_type_name'] = "运维人员";
            break;
          case 5:
            data['manager_type_name'] = "介绍人";
            break;
          case 6:
            data['manager_type_name'] = "酒店管理员";
            break;
          case 7:
            data['manager_type_name'] = "补货员";
            break;
        }
        var showPer = "none";
        if(Number(data.manager_type) == 3 || Number(data.manager_type) == 5 || Number(data.manager_type) == 6){
          showPer = "block";
        }
        PageThis.setData({
          "managerDetail": data,
          "showPer":showPer
        })
      }
    })
  },
  withdrawal_balance(){
    var PageThis = this;
    var id = PageThis.data.managerId;
    wx.showModal({
      title: '温馨提示',
      content: '确定要提取该用户余额？',
      success(ret){
        if(ret.confirm){
          wx.request({
            url: app.globalData.serverInfo.gateWayUrl,
            header: {
              'content-type': 'application/json'
            },
            method: 'POST',
            data: {
              api_name: "extract_manager_balance",
              manager_id: id,
              login_manager_id: PageThis.data.userInfo.manager_id
            },
            success:function(ret){
              if(Number(ret.data.state) === 1){
                wx.showToast({
                  title: ret.data.msg,
                })
              }else{
                wx.showToast({
                  title: ret.data.msg,
                  icon: 'none'
                })
              }
            }
          })
        }else{

        }
      }
    })
  },
  disable_account(){
    var PageThis = this;
    var id = PageThis.data.managerId;
    wx.showModal({
      title: '温馨提示',
      content: '确定要禁用该用户账号？',
      success(ret){
        if(ret.confirm){
          wx.request({
            url: app.globalData.serverInfo.gateWayUrl,
            header: {
              'content-type': 'application/json'
            },
            method: 'POST',
            data: {
              api_name: "disable_manager_info",
              manager_id: id,
              login_manager_id: PageThis.data.userInfo.manager_id
            },
            success:function(ret){
              if(Number(ret.data.state) === 1){
                wx.showToast({
                  title: ret.data.msg,
                })
              }else{
                wx.showToast({
                  title: ret.data.msg,
                  icon: 'none'
                })
              }
            }
          })
        }else{

        }
      }
    })
  },
  reset_password(){
    var PageThis = this;
    var id = PageThis.data.managerId;
    wx.showModal({
      title: '温馨提示',
      content: '该用户登陆密码将会重置为【123456】',
      success(ret){
        if(ret.confirm){
          wx.request({
            url: app.globalData.serverInfo.gateWayUrl,
            header: {
              'content-type': 'application/json'
            },
            method: 'POST',
            data: {
              api_name: "reset_manager_password",
              manager_id: id,
              login_manager_id: PageThis.data.userInfo.manager_id
            },
            success:function(ret){
              if(Number(ret.data.state) === 1){
                wx.showToast({
                  title: ret.data.msg,
                })
              }else{
                wx.showToast({
                  title: ret.data.msg,
                  icon: 'none'
                })
              }
            }
          })
        }else{

        }
      }
    })
  }
})