// pages/userList/index.js
const app = getApp();
Page({
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    userType: ['平台管理员', '生产厂商', '合伙人', '运维人员', '介绍人', '酒店管理员', '补货员'],
    userList: [],
    search_value: "",
  },
  onLoad: function (options) {
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
  },
  onShow: function () {
    this.getManagerList();
  },
  //**页面跳转 */
  navigateTo: function (e) {
    var _url = e.currentTarget.dataset.url;
    var _id = e.currentTarget.dataset.id;
    wx.navigateTo({
      url: _url + "?id=" + _id,
    })
  },
  getManagerList:function(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "manager_list",
        keywords: PageThis.data.search_value,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(res){
        var data = res.data.data;
        for (var i in data){
          data[i]['manager_type'] = PageThis.data.userType[data[i]['manager_type']-1];
        }
        PageThis.setData({
          "userList": data
        })
      }
    })
  },
  inputChange:function(e){
    var PageThis = this;
    PageThis.setData({
      "search_value": e.detail.value
    })
  }
})