const app = getApp();
Page({
  data: {
    userInfo:{},
    list:[]
  },
  onLoad: function (options) {
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
  },
  onShow: function () {
    this.getDeviceRepair();
  },
  getDeviceRepair(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "get_device_repair",
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(res){
        var ret = res.data;
        if(Number(ret.state) === 1){
          var list = ret.data;
          for(var i in list){
            list[i].repair_content = JSON.parse(list[i].repair_content);
            var str = "待维修"
            switch(list[i].repair_state){
              case 1:
                str = "待维修";
                break;
              case 2:
                str = "维修中";
                break;
              case 3:
                str = "已维修";
                break;
              case 4:
                str = "已完成";
                break;
            }
            list[i].repair_state_name = str;
            if(Number(list[i].repair_delivery_type) == 1){
              list[i].repair_delivery_type_name = "自取";
            }else if(Number(list[i].repair_delivery_type) == 2){
              list[i].repair_delivery_type_name = "快递";
            }
          }
          PageThis.setData({
            list:list
          })
        }
      }
    })
  }
})