// pages/bindDevice/index.js
const app = getApp();
Page({
  data: {
    userInfo: wx.getStorageSync('userInfo'),
    hotelId: 0,
    deviceList: [],
    deviceListValue:[],
    hotelInfo: {},
    bindList: [],
    managerList: [],
    managerValue: [],
    managerName: "请选择管理员",
    managerId: 0
  },
  onLoad: function (options) {
    var id = options.id;
    var PageThis = this;
    PageThis.setData({
      userInfo:wx.getStorageSync('userInfo')
    })
    this.setData({
      hotelId:id
    })
    this.getHotelInfo();
    this.getManagerList();
    this.getDeviceList();
  },
  getHotelInfo:function(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "hotel_detail",
        hotel_id: PageThis.data.hotelId,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success:function(res){
        var data = res.data.data;
        PageThis.setData({
          hotelInfo: data
        })
      }
    })
  },
  getDeviceList:function(){
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "device_list",
        bind_value: 2,
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success: function (res) {
        var data = res.data.data;
        var deviceList = [];
        for (var i in data){
          deviceList.push(data[i].dev_no)
        }
        PageThis.setData({
          deviceList: deviceList,
          deviceListValue: data
        })
      }
    })
  },
  addDevice:function(){
    var PageThis = this;
    var bindList = PageThis.data.bindList;
    bindList.push({
      index:bindList.length,
      deviceId:0,
      devNo:"请选择绑定设备",
      dev_hotel_room:"",
      dev_room_address: "",
    });
    PageThis.setData({
      bindList: bindList
    })
  },

  delDevice:function(e){
    var PageThis = this;
    var index = e.currentTarget.dataset.index;
    var bindList = PageThis.data.bindList;
    var newList = [];
    for (var i in bindList){
      if (bindList[i].index != index){
        bindList[i].index = newList.length;
        newList.push(bindList[i]);
      }
    }
    PageThis.setData({
      bindList: newList
    })
  },
  scanAdd:function(){
    var PageThis = this;
    var bindList = PageThis.data.bindList;
    wx.scanCode({
      scanType:['qrCode'],
      success (res) {
        console.log(res)
        var scan_url = res.result;
        var code = scan_url.replace(app.globalData.serverInfo.qrReplaceUrl,'');
        if(code != ""){
          wx.showModal({
            title: '绑定设备',
            content: '确定绑定设备编号为：'+code+"的设备？",
            success (res) {
              if (res.confirm) {
                bindList.push({
                  index:bindList.length,
                  deviceId:0,
                  devNo:code,
                  dev_hotel_room:"",
                  dev_room_address: "",
                });
                PageThis.setData({
                  bindList: bindList
                })
              } else if (res.cancel) {
                console.log('用户点击取消')
              }
            }
          })
        }
      }
    })
  },
  sureBind:function(){
    var PageThis = this;
    var bindList = PageThis.data.bindList;
    var ids = [];
    for (var i in bindList){
      ids.push(bindList[i].deviceId);
    }
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "bind_device_hotel",
        login_manager_id: PageThis.data.userInfo.manager_id,
        dev_list:PageThis.data.bindList,
        hotel_id:PageThis.data.hotelId,
        hotel_manager_id: PageThis.data.managerId
      },
      success:function(res){
        res = res.data;
        if(res.state == 1){
          wx.showToast({
            title: "绑定成功",
            icon: "success",
            duration: 2000
          })
          setTimeout(function(){
            wx.navigateBack();
          },2000)
        }else{
          wx.showToast({
            title: res.msg,
            icon:"none",
            duration:1500
          })
        }
      }
    })
  },
  getManagerList: function () {
    var PageThis = this;
    wx.request({
      url: app.globalData.serverInfo.gateWayUrl,
      header: {
        'content-type': 'application/json'
      },
      method: 'POST',
      data: {
        api_name: "manager_list",
        login_manager_id: PageThis.data.userInfo.manager_id
      },
      success: function (res) {
        var data = res.data.data;
        var managerList = [];
        var managerValue = [];
        for (var i in data) {
          if (data[i].manager_type == 6){
            managerList.push(data[i]['manager_username']);
            managerValue.push(data[i])
          }
        }
        PageThis.setData({
          "managerList": managerList,
          "managerValue": managerValue
        })
      }
    })
  },
  pickerChange:function(e){
    var PageThis = this;
    var index = e.currentTarget.dataset.index;
    var name = e.currentTarget.dataset.name;
    var id = e.detail.value;
    if (name == "devNo"){
      var deviceList = PageThis.data.deviceList;
      var deviceListValue = PageThis.data.deviceListValue;
      var bindList = PageThis.data.bindList;
      bindList[index]['deviceId'] = deviceListValue[id]['dev_id'];
      bindList[index]['devNo'] = deviceListValue[id]['dev_no'];
      PageThis.setData({
        "bindList": bindList
      })
    }else{
      var managerList = PageThis.data.managerList;
      var managerValue = PageThis.data.managerValue;
      PageThis.setData({
        "managerId": managerValue[id]['manager_id'],
        "managerName": managerList[id]
      })
    }
  },
  inputChange:function(e){
    var PageThis = this;
    var index = e.currentTarget.dataset.index;
    var name = e.currentTarget.dataset.name;
    var bindList = PageThis.data.bindList;
    bindList[index][name] = e.detail.value;
    PageThis.setData({
      "bindList": bindList
    })
  }
})